/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.entity.projectile;

import com.google.common.base.MoreObjects;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.undying.alex_cave_addon.Config;
import net.undying.alex_cave_addon.entity.ModEntities;
import net.undying.alex_cave_addon.particle.ModParticles;
import org.jetbrains.annotations.Nullable;

public class MagneticOrbEntity
extends Projectile {
    public static final byte SET_GROW_ID = 100;
    public static final byte SET_SHRINK_ID = 101;
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(MagneticOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(MagneticOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DISPLAY = SynchedEntityData.m_135353_(MagneticOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GROW_TICKS = SynchedEntityData.m_135353_(MagneticOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public double xPower;
    public double yPower;
    public double zPower;
    private int lifetime;
    protected int growTicks;
    protected boolean shrink;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;

    public MagneticOrbEntity(Level level, @Nullable Entity owner, Vec3 pos, Vec3 movement, int type) {
        this((EntityType<MagneticOrbEntity>)((EntityType)ModEntities.MAGNETIC_ORB.get()), level);
        this.m_20219_(pos);
        this.m_20090_();
        this.m_5602_(owner);
        this.setOrbType(type);
        Vec3 vec = movement.m_82541_();
        if (movement.m_82553_() != 0.0) {
            this.xPower = vec.f_82479_ * 0.1;
            this.yPower = vec.f_82480_ * 0.1;
            this.zPower = vec.f_82481_ * 0.1;
        }
    }

    public MagneticOrbEntity(EntityType<MagneticOrbEntity> type, Level level) {
        super(type, level);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity owner = this.m_19749_();
        int i = owner == null ? 0 : owner.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), i, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        double xa = packet.m_131503_();
        double ya = packet.m_131504_();
        double za = packet.m_131505_();
        double d = Math.sqrt(xa * xa + ya * ya + za * za);
        if (d != 0.0) {
            this.xPower = xa / d * 0.1;
            this.yPower = ya / d * 0.1;
            this.zPower = za / d * 0.1;
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DISPLAY, (Object)false);
        this.f_19804_.m_135372_(GROW_TICKS, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (data == GROW_TICKS) {
            this.growTicks = 0;
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("OrbType", this.getOrbType());
        nbt.m_128350_("OrbSize", this.getSize());
        nbt.m_128405_("Lifetime", this.lifetime);
        nbt.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (!this.m_9236_().f_46443_) {
            ListTag list;
            this.setOrbType(nbt.m_128451_("OrbType"));
            if (nbt.m_128425_("OrbSize", 99)) {
                this.setSize(nbt.m_128457_("OrbSize"));
            }
            this.lifetime = nbt.m_128451_("Lifetime");
            if (nbt.m_128425_("power", 9) && (list = nbt.m_128437_("power", 6)).size() == 3) {
                this.xPower = list.m_128772_(0);
                this.yPower = list.m_128772_(1);
                this.zPower = list.m_128772_(2);
            }
        }
    }

    public int getOrbType() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    public void setOrbType(int type) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(TYPE, (Object)Mth.m_14045_((int)type, (int)0, (int)2));
        }
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float value) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(value));
        }
    }

    public boolean isDisplay() {
        return (Boolean)this.f_19804_.m_135370_(DISPLAY);
    }

    public void setDisplay(boolean value) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DISPLAY, (Object)value);
        }
    }

    public void setGrow(int ticks, boolean shrink) {
        this.f_19804_.m_135381_(GROW_TICKS, (Object)ticks);
        this.m_9236_().m_7605_((Entity)this, shrink ? (byte)101 : 100);
    }

    public float getGrow(float partialTick) {
        if ((Integer)this.f_19804_.m_135370_(GROW_TICKS) > 0) {
            float f = ((float)this.growTicks + partialTick) / (float)((Integer)this.f_19804_.m_135370_(GROW_TICKS)).intValue();
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            return this.shrink ? 1.0f - f : f;
        }
        return 1.0f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.m_6095_().m_20680_().m_20388_(this.getSize());
    }

    public boolean m_6783_(double distance) {
        double d = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d)) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 100: {
                this.shrink = false;
                break;
            }
            case 101: {
                this.shrink = true;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public void m_8119_() {
        Entity owner = this.m_19749_();
        if (this.m_9236_().f_46443_ || (owner == null || !owner.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_()) && ((Boolean)Config.COMMON.ENABLE_MAGNETIC_ORBS.get()).booleanValue()) {
            super.m_8119_();
            HitResult hit = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hit.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hit) && !this.isDisplay()) {
                this.m_6532_(hit);
            }
            this.m_20101_();
            Vec3 movement = this.m_20184_();
            double xd = this.m_20185_() + movement.f_82479_;
            double yd = this.m_20186_() + movement.f_82480_;
            double zd = this.m_20189_() + movement.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
            if (!this.m_9236_().f_46443_) {
                this.m_20256_(movement.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)this.getInertia()));
                this.m_6034_(xd, yd, zd);
                if (!this.isDisplay()) {
                    ++this.lifetime;
                }
                if (this.lifetime > 240) {
                    this.m_146870_();
                }
                if (!this.isDisplay()) {
                    if (this.getOrbType() == 1) {
                        this.pullMobs();
                    }
                    if (this.getOrbType() == 2) {
                        this.breakBlocks();
                    }
                }
            } else {
                ++this.growTicks;
                for (int i = 0; i < 4; ++i) {
                    this.addParticle();
                }
                if (this.lerpSteps > 0) {
                    double x = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
                    double y = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
                    double z = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
                    --this.lerpSteps;
                    this.m_6034_(x, y, z);
                }
                this.m_20256_(new Vec3(this.f_19790_, this.f_19791_, this.f_19792_).m_82505_(this.m_20182_()));
            }
        } else {
            this.m_146870_();
        }
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int steps, boolean flag) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = Math.min(steps, 2);
    }

    private void addParticle() {
        Vec3 vec = Vec3.m_82498_((float)(this.f_19796_.m_188501_() * 360.0f), (float)(this.f_19796_.m_188501_() * 360.0f));
        vec = vec.m_82490_((double)(2.0f + this.f_19796_.m_188501_()));
        Vec3 pos = this.m_20191_().m_82399_().m_82549_(vec);
        int lifetime = 20 + this.f_19796_.m_188503_(5);
        int color = MagneticOrbEntity.getOrbColor(this.getOrbType(), 0.5f + this.f_19796_.m_188501_() * 0.35f);
        this.m_9236_().m_6493_((ParticleOptions)ModParticles.MAGNETIC_ORB.get(), true, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)this.m_19879_(), (double)color, (double)lifetime);
    }

    public void m_6686_(double xd, double yd, double zd, float power, float offset) {
        super.m_6686_(xd, yd, zd, power, offset);
        Vec3 movement = this.m_20184_();
        this.m_20256_(Vec3.f_82478_);
        Vec3 vec = movement.m_82541_();
        if (movement.m_82553_() != 0.0) {
            this.xPower = vec.f_82479_ * 0.1;
            this.yPower = vec.f_82480_ * 0.1;
            this.zPower = vec.f_82481_ * 0.1;
        }
    }

    protected void m_6532_(HitResult hit) {
        super.m_6532_(hit);
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        if (this.getOrbType() != 1) {
            this.explode(this.getOrbType() == 2 ? 4.5f : 3.0f);
        }
    }

    public void explode(float power) {
        if (!this.m_9236_().f_46443_ && !this.isDisplay()) {
            Level.ExplosionInteraction interaction = Level.ExplosionInteraction.NONE;
            if (!((Boolean)Config.COMMON.MAGNETIC_ORBS_NO_BREAK.get()).booleanValue() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this.m_19749_())) {
                interaction = Level.ExplosionInteraction.MOB;
            }
            this.m_9236_().m_254849_((Entity)MoreObjects.firstNonNull((Object)this.m_19749_(), (Object)((Object)this)), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), power, interaction);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        Entity entity = hit.m_82443_();
        if (!this.m_9236_().f_46443_ && this.getOrbType() == 0 && this.m_5603_(entity)) {
            LivingEntity living;
            Entity entity2;
            float damage = 20.0f;
            float knockback = 1.5f;
            DamageSource source = this.m_269291_().m_269299_((Entity)this, (entity2 = this.m_19749_()) instanceof LivingEntity ? (living = (LivingEntity)entity2) : null);
            if (entity.m_6469_(source, damage)) {
                Vec3 vec = this.m_20182_().m_82505_(entity.m_20182_());
                vec = vec.m_82490_((double)knockback);
                vec = vec.m_82549_(this.m_20184_().m_82490_(0.5));
                entity.m_5997_(vec.f_82479_, vec.f_82480_ + 0.1, vec.f_82481_);
            }
        }
    }

    protected void pullMobs() {
        Entity player = (Entity)MoreObjects.firstNonNull((Object)this.m_19749_(), (Object)((Object)this));
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
            double z;
            double y;
            double x;
            double d;
            if (!this.canPull(player, entity) || !this.isMobNotInCreativeMode(entity) || !((d = Math.sqrt((x = this.m_20185_() - entity.m_20185_()) * x + (y = this.m_20227_(0.5) - entity.m_20186_()) * y + (z = this.m_20189_() - entity.m_20189_()) * z)) < 12.0)) continue;
            double motionX = entity.m_20184_().f_82479_ + x / d * 0.2;
            double motionY = entity.m_20184_().f_82480_ + y / d * 0.2;
            double motionZ = entity.m_20184_().f_82481_ + z / d * 0.2;
            entity.f_19864_ = true;
            entity.m_20334_(motionX, motionY, motionZ);
            entity.m_6001_(motionX, motionY, motionZ);
        }
    }

    protected void breakBlocks() {
        if (this.lifetime < 160 && !((Boolean)Config.COMMON.MAGNETIC_ORBS_NO_BREAK.get()).booleanValue() && (this.m_19749_() instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this.m_19749_()))) {
            BlockPos.m_121921_((AABB)this.m_20191_().m_82400_(3.0)).forEach(pos -> {
                if (pos.m_252807_().m_82554_(this.m_20191_().m_82399_()) <= 3.0 && !this.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_13070_)) {
                    this.m_9236_().m_46953_(pos, true, this.m_19749_());
                }
            });
        }
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(3.0))) {
            VoxelShape shape = Shapes.m_83064_((AABB)entity.m_20191_());
            Optional vec = shape.m_166067_(this.m_20191_().m_82399_());
            vec.ifPresent(vec1 -> {
                if (vec1.m_82554_(this.m_20191_().m_82399_()) < 2.0 && this.m_5603_(entity)) {
                    float damage = 30.0f;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        double d = this.m_20191_().m_82323_(entity.m_20191_()).m_82309_();
                        damage = (float)((double)damage + (double)living.m_21233_() * 0.5 * (double)((float)(d /= entity.m_20191_().m_82309_())));
                    }
                    DamageSource source = this.m_269291_().m_269104_((Entity)this, this.m_19749_());
                    entity.m_6469_(source, damage);
                }
            });
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (this.m_19749_() != null && (entity == this.m_19749_() || entity.m_7307_(this.m_19749_()))) {
            return false;
        }
        return !entity.f_19794_ && super.m_5603_(entity);
    }

    protected boolean isMobNotInCreativeMode(Entity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        return !((Player)entity).m_7500_() && !entity.m_5833_();
    }

    protected boolean canPull(Entity player, Entity entity) {
        if (player.m_5647_() != null || entity.m_5647_() != null) {
            return player.m_5647_() != entity.m_5647_();
        }
        return this.m_5603_(entity);
    }

    protected float getInertia() {
        return 0.95f;
    }

    public static int getOrbColor(int type, float saturation) {
        float hue = type == 0 ? 0.0f : (type == 1 ? 220.0f : 275.0f);
        return Color.HSBtoRGB(hue / 360.0f, saturation, 1.0f);
    }
}

