/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.entity.ability;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.undying.alex_cave_addon.client.animation.PlayerAnimations;
import net.undying.alex_cave_addon.entity.ModEntities;
import net.undying.alex_cave_addon.entity.ability.ISkill;
import net.undying.alex_cave_addon.entity.ability.PlayerAccess;
import net.undying.alex_cave_addon.entity.projectile.MagneticOrbEntity;

public class RedOrbSkill
implements ISkill {
    @Override
    public void onStart(Player player) {
    }

    @Override
    public void tick(Player player, int ticks) {
        MagneticOrbEntity orb;
        if (ticks == 1) {
            orb = new MagneticOrbEntity((EntityType<MagneticOrbEntity>)((EntityType)ModEntities.MAGNETIC_ORB.get()), player.m_9236_());
            orb.m_5602_((Entity)player);
            orb.setOrbType(0);
            orb.setSize(0.4f);
            orb.setDisplay(true);
            orb.m_6842_(true);
            this.positionOrb(player, orb);
            player.m_9236_().m_7967_((Entity)orb);
            PlayerAccess.setOrb(player, 0, orb);
            this.playSound((Entity)player, SoundEvents.f_12616_, 1.0f, 1.0f);
        }
        orb = PlayerAccess.getOrb(player, 0);
        if (ticks > 1 && ticks < 22 && orb != null) {
            this.positionOrb(player, orb);
        }
        if (ticks == 8 && orb != null) {
            orb.m_6842_(false);
            orb.setGrow(10, false);
        }
        if (ticks == 22) {
            if (orb != null) {
                orb.m_37251_((Entity)player, player.m_146909_(), player.f_20885_, 0.0f, 1.0f, 0.0f);
                orb.setDisplay(false);
            }
            PlayerAccess.setOrb(player, 0, null);
        }
        PlayerAccess.rotateBody(player);
    }

    @Override
    public void onEnd(Player player, boolean finished) {
        MagneticOrbEntity orb = PlayerAccess.getOrb(player, 0);
        if (orb != null) {
            orb.m_146870_();
        }
        PlayerAccess.setOrb(player, 0, null);
    }

    protected void positionOrb(Player player, MagneticOrbEntity entity) {
        Vec3 pos = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.75, 0.0);
        pos = pos.m_82549_(Vec3.m_82498_((float)0.0f, (float)player.f_20883_).m_82490_(0.75));
        entity.m_146884_(pos.m_82492_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
        entity.m_20256_(Vec3.f_82478_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AnimationDefinition getAnimation(Player player) {
        return PlayerAnimations.RED_ORB;
    }
}

