/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.entity.ability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.undying.alex_cave_addon.entity.ability.Skill;
import net.undying.alex_cave_addon.entity.projectile.MagneticOrbEntity;
import org.jetbrains.annotations.Nullable;

public interface PlayerAccess {
    public CompoundTag alexcaveaddon_getPlayerData();

    @Nullable
    public MagneticOrbEntity alexcaveaddon_getRedOrb();

    @Nullable
    public MagneticOrbEntity alexcaveaddon_getBlueOrb();

    @Nullable
    public MagneticOrbEntity alexcaveaddon_getPurpleOrb();

    public void alexcaveaddon_setRedOrb(@Nullable MagneticOrbEntity var1);

    public void alexcaveaddon_setBlueOrb(@Nullable MagneticOrbEntity var1);

    public void alexcaveaddon_setPurpleOrb(@Nullable MagneticOrbEntity var1);

    public int alexcaveaddon_getClientSkillId();

    public int alexcaveaddon_getClientSkillTicks();

    public float alexcaveaddon_getPartialTick();

    public void alexcaveaddon_setPartialTick(float var1);

    public static CompoundTag getPlayerData(Player player) {
        return ((PlayerAccess)player).alexcaveaddon_getPlayerData();
    }

    @Nullable
    public static MagneticOrbEntity getOrb(Player player, int type) {
        switch (type) {
            case 0: {
                return ((PlayerAccess)player).alexcaveaddon_getRedOrb();
            }
            case 1: {
                return ((PlayerAccess)player).alexcaveaddon_getBlueOrb();
            }
            case 2: {
                return ((PlayerAccess)player).alexcaveaddon_getPurpleOrb();
            }
        }
        return null;
    }

    public static void setOrb(Player player, int type, @Nullable MagneticOrbEntity orb) {
        switch (type) {
            case 0: {
                ((PlayerAccess)player).alexcaveaddon_setRedOrb(orb);
                break;
            }
            case 1: {
                ((PlayerAccess)player).alexcaveaddon_setBlueOrb(orb);
                break;
            }
            case 2: {
                ((PlayerAccess)player).alexcaveaddon_setPurpleOrb(orb);
            }
        }
    }

    public static int getSkillId(Player player) {
        CompoundTag data = PlayerAccess.getPlayerData(player);
        if (!data.m_128425_("SkillId", 99)) {
            data.m_128405_("SkillId", -1);
        }
        return data.m_128451_("SkillId");
    }

    public static void setSkillId(Player player, int id) {
        if (!player.m_9236_().f_46443_) {
            CompoundTag data = PlayerAccess.getPlayerData(player);
            data.m_128405_("SkillId", id);
        }
    }

    public static int getSkillTicks(Player player) {
        CompoundTag data = PlayerAccess.getPlayerData(player);
        if (!data.m_128425_("SkillTicks", 99)) {
            data.m_128405_("SkillTicks", 0);
        }
        return data.m_128451_("SkillTicks");
    }

    public static void setSkillTicks(Player player, int ticks) {
        if (!player.m_9236_().f_46443_) {
            CompoundTag data = PlayerAccess.getPlayerData(player);
            data.m_128405_("SkillTicks", Math.max(ticks, 0));
        }
    }

    public static void setSkill(Player player, @Nullable Skill skill, boolean finished) {
        Skill prev;
        if (!player.m_9236_().f_46443_ && skill != (prev = PlayerAccess.getSkill(player))) {
            if (prev != null) {
                prev.data.onEnd(player, finished);
            }
            if (skill != null) {
                PlayerAccess.setSkillId(player, skill.ordinal());
                PlayerAccess.setSkillTicks(player, skill.duration + 1);
                skill.data.onStart(player);
            } else {
                PlayerAccess.setSkillId(player, -1);
                PlayerAccess.setSkillTicks(player, 0);
            }
        }
    }

    @Nullable
    public static Skill getSkill(Player player) {
        int id = PlayerAccess.getSkillId(player);
        if (PlayerAccess.getSkillTicks(player) > 0) {
            return Skill.fromId(id);
        }
        return null;
    }

    public static int getClientSkillId(Player player) {
        return ((PlayerAccess)player).alexcaveaddon_getClientSkillId();
    }

    public static int getClientSkillTicks(Player player) {
        return ((PlayerAccess)player).alexcaveaddon_getClientSkillTicks();
    }

    public static float getPartialTick(Player player) {
        return ((PlayerAccess)player).alexcaveaddon_getPartialTick();
    }

    public static void setPartialTick(Player player, float partialTick) {
        ((PlayerAccess)player).alexcaveaddon_setPartialTick(partialTick);
    }

    public static void rotateBody(Player player) {
        float f = Mth.m_14177_((float)(player.f_20885_ - player.f_20883_));
        player.f_20883_ = (float)((double)player.f_20883_ + (double)f * 0.2);
    }
}

