/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.entity.ability;

import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.undying.alex_cave_addon.client.animation.PlayerAnimations;
import net.undying.alex_cave_addon.entity.ModEntities;
import net.undying.alex_cave_addon.entity.ability.ISkill;
import net.undying.alex_cave_addon.entity.ability.PlayerAccess;
import net.undying.alex_cave_addon.entity.projectile.MagneticOrbEntity;

public class BlueOrbSkill
implements ISkill {
    @Override
    public void onStart(Player player) {
    }

    @Override
    public void tick(Player player, int ticks) {
        MagneticOrbEntity orb;
        if (ticks == 1) {
            orb = new MagneticOrbEntity((EntityType<MagneticOrbEntity>)((EntityType)ModEntities.MAGNETIC_ORB.get()), player.m_9236_());
            orb.m_5602_((Entity)player);
            orb.setOrbType(1);
            orb.setSize(2.0f);
            orb.setGrow(13, false);
            this.positionOrb(player, orb, ticks);
            player.m_9236_().m_7967_((Entity)orb);
            PlayerAccess.setOrb(player, 1, orb);
            this.playSound((Entity)player, SoundEvents.f_12616_, 1.0f, 1.0f);
        }
        orb = PlayerAccess.getOrb(player, 1);
        if (ticks > 1 && ticks < 33 && orb != null) {
            this.positionOrb(player, orb, ticks);
        }
        if (ticks == 33) {
            if (orb != null) {
                orb.explode(4.0f);
            }
            PlayerAccess.setOrb(player, 1, null);
        }
        PlayerAccess.rotateBody(player);
    }

    @Override
    public void onEnd(Player player, boolean finished) {
        MagneticOrbEntity orb = PlayerAccess.getOrb(player, 1);
        if (orb != null) {
            orb.m_146870_();
        }
        PlayerAccess.setOrb(player, 1, null);
    }

    protected void positionOrb(Player player, MagneticOrbEntity entity, int ticks) {
        Vec3 pos = player.m_146892_();
        float f = Mth.m_14036_((float)((float)ticks / 10.0f), (float)0.0f, (float)1.0f) * -90.0f;
        float f1 = player.m_5737_() == HumanoidArm.RIGHT ? -45.0f : 45.0f;
        pos = pos.m_82549_(Vec3.m_82498_((float)f, (float)(player.f_20883_ + f1)).m_82542_(1.0, 2.0, 1.0));
        entity.m_146884_(pos);
        entity.m_20256_(Vec3.f_82478_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AnimationDefinition getAnimation(Player player) {
        return PlayerAnimations.BLUE_ORB;
    }
}

