/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.undying.alex_cave_addon.client.render.ModRenderType;
import net.undying.alex_cave_addon.entity.projectile.MagneticOrbEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MagneticOrbRenderer
extends EntityRenderer<MagneticOrbEntity> {
    public MagneticOrbRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(MagneticOrbEntity entity) {
        return new ResourceLocation("");
    }

    public void render(MagneticOrbEntity entity, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light) {
        if (entity.m_20145_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.25 * (double)entity.getSize(), 0.0);
        float time = (float)entity.f_19797_ + partialTick;
        int type = entity.getOrbType();
        VertexConsumer builder1 = buffer.m_6299_(ModRenderType.getEntityLightning());
        float scale = 1.0f + Mth.m_14031_((float)(time * 18.0f * ((float)Math.PI / 180))) * 0.1f;
        poseStack.m_85841_(scale *= entity.getSize() * entity.getGrow(partialTick), scale, scale);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(time * 4.5f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time * 18.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(time * 9.0f));
        this.renderCube(poseStack, builder1, MagneticOrbRenderer.getColor(type, 0.85f), 8.0f);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(time * -4.5f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time * -32.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(time * -9.0f));
        this.renderCube(poseStack, builder1, MagneticOrbRenderer.getColor(type, 0.5f), 4.5f);
        poseStack.m_85849_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(time * 9.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time * 36.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(time * 18.0f));
        scale = 1.0f + Mth.m_14031_((float)(time * 48.0f * ((float)Math.PI / 180))) * 0.05f;
        poseStack.m_85841_(scale, scale, scale);
        this.renderCube(poseStack, builder1, MagneticOrbRenderer.getColor(type, 0.0f), 2.0f);
        poseStack.m_85849_();
    }

    protected void renderCube(PoseStack poseStack, VertexConsumer builder1, VertexConsumer builder2, float[] color, float size) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.004f, 1.004f, 1.004f);
        this.renderCube(poseStack, builder2, color, size);
        poseStack.m_85849_();
        this.renderCube(poseStack, builder1, color, size);
    }

    protected void renderCube(PoseStack poseStack, VertexConsumer builder, float[] color, float size) {
        poseStack.m_85836_();
        poseStack.m_85841_(size /= 16.0f, size, size);
        for (Direction face : Direction.values()) {
            poseStack.m_85836_();
            poseStack.m_252781_(face.m_253075_());
            this.renderFace(poseStack, builder, color);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    protected void renderFace(PoseStack poseStack, VertexConsumer builder, float[] color) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        this.drawVertex(matrix, normal, builder, 0.5f, -0.5f, color);
        this.drawVertex(matrix, normal, builder, 0.5f, 0.5f, color);
        this.drawVertex(matrix, normal, builder, -0.5f, 0.5f, color);
        this.drawVertex(matrix, normal, builder, -0.5f, -0.5f, color);
        poseStack.m_85849_();
    }

    protected void drawVertex(Matrix4f matrix, Matrix3f normal, VertexConsumer builder, float x, float z, float[] color) {
        builder.m_252986_(matrix, x, 0.0f, z).m_85950_(color[0], color[1], color[2], 0.99f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static float[] getColor(int type, float saturation) {
        float[] color = new float[3];
        int i = MagneticOrbEntity.getOrbColor(type, saturation);
        color[0] = (float)(i >> 16 & 0xFF) / 255.0f;
        color[1] = (float)(i >> 8 & 0xFF) / 255.0f;
        color[2] = (float)(i & 0xFF) / 255.0f;
        return color;
    }
}

