/*
 * Decompiled with CFR 0.152.
 */
package net.undying.alex_cave_addon.client.animation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.util.Mth;
import net.undying.alex_cave_addon.client.animation.PlayerAnimations;
import org.joml.Vector3f;

public class PlayerKeyframeAnimations {
    private static final Vector3f ANIM_VEC_CACHE = new Vector3f();
    private static final ModelPart ANIM_PART = new ModelPart(List.of(), Map.of());

    public static void animate(PlayerModel<?> model, AnimationDefinition anim, long time, float scale, boolean mirror) {
        float time1 = PlayerKeyframeAnimations.getElapsedSeconds(anim, time);
        for (Map.Entry entry : anim.f_232257_().entrySet()) {
            Optional<ModelPart> optional = PlayerKeyframeAnimations.getPartFromString(model, (String)entry.getKey(), mirror);
            List channels = (List)entry.getValue();
            optional.ifPresent(part -> {
                float resetAmount = PlayerKeyframeAnimations.getResetAmount(anim, time);
                channels.forEach(channel -> {
                    boolean rot;
                    Keyframe[] keyframes = channel.f_232212_();
                    int index = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, i -> time1 <= keyframes[i].f_232283_()) - 1);
                    int nextIndex = Math.min(keyframes.length - 1, index + 1);
                    Keyframe current = keyframes[index];
                    Keyframe next = keyframes[nextIndex];
                    float timestamp = time1 - current.f_232283_();
                    float timestamp1 = 0.0f;
                    if (nextIndex != index) {
                        timestamp1 = Mth.m_14036_((float)(timestamp / (next.f_232283_() - current.f_232283_())), (float)0.0f, (float)1.0f);
                    }
                    next.f_232285_().m_232222_(ANIM_VEC_CACHE, timestamp1, keyframes, index, nextIndex, scale);
                    boolean pos = channel.f_232211_() == AnimationChannel.Targets.f_232250_;
                    boolean bl = rot = channel.f_232211_() == AnimationChannel.Targets.f_232251_;
                    if (!((String)entry.getKey()).equals("head") || !rot || anim != PlayerAnimations.PURPLE_ORB) {
                        PlayerKeyframeAnimations.lerpToDefault(part, resetAmount, pos, rot);
                    }
                    if (pos && mirror) {
                        ANIM_VEC_CACHE.mul(-1.0f, 1.0f, 1.0f);
                    }
                    if (rot && mirror) {
                        ANIM_VEC_CACHE.mul(1.0f, -1.0f, -1.0f);
                    }
                    channel.f_232211_().m_232247_(part, ANIM_VEC_CACHE);
                });
            });
        }
    }

    public static Vector3f getAnimValue(AnimationDefinition anim, String part, TransformType type, long time, float scale) {
        Vector3f value = new Vector3f();
        Map animMap = anim.f_232257_();
        if (animMap.containsKey(part)) {
            float f = PlayerKeyframeAnimations.getElapsedSeconds(anim, time);
            List channels = (List)animMap.get(part);
            ANIM_PART.m_233569_();
            channels.forEach(channel -> {
                Keyframe[] keyframes = channel.f_232212_();
                int index = Math.max(0, Mth.m_14049_((int)0, (int)keyframes.length, i -> f <= keyframes[i].f_232283_()) - 1);
                int nextIndex = Math.min(keyframes.length - 1, index + 1);
                Keyframe current = keyframes[index];
                Keyframe next = keyframes[nextIndex];
                float frameTime = f - current.f_232283_();
                float frameTime1 = 0.0f;
                if (nextIndex != index) {
                    frameTime1 = Mth.m_14036_((float)(frameTime / (next.f_232283_() - current.f_232283_())), (float)0.0f, (float)1.0f);
                }
                next.f_232285_().m_232222_(ANIM_VEC_CACHE, frameTime1, keyframes, index, nextIndex, scale);
                channel.f_232211_().m_232247_(ANIM_PART, ANIM_VEC_CACHE);
            });
            switch (type) {
                case POSITION: {
                    value.add(PlayerKeyframeAnimations.ANIM_PART.f_104200_, PlayerKeyframeAnimations.ANIM_PART.f_104201_, PlayerKeyframeAnimations.ANIM_PART.f_104202_);
                    break;
                }
                case ROTATION: {
                    value.add(PlayerKeyframeAnimations.ANIM_PART.f_104203_, PlayerKeyframeAnimations.ANIM_PART.f_104204_, PlayerKeyframeAnimations.ANIM_PART.f_104205_);
                    break;
                }
                case SCALE: {
                    value.add(PlayerKeyframeAnimations.ANIM_PART.f_233553_ - 1.0f, PlayerKeyframeAnimations.ANIM_PART.f_233554_ - 1.0f, PlayerKeyframeAnimations.ANIM_PART.f_233555_ - 1.0f);
                }
            }
            ANIM_PART.m_233569_();
        }
        return value;
    }

    private static float getElapsedSeconds(AnimationDefinition anim, long time) {
        float f = (float)time / 1000.0f;
        return anim.f_232256_() ? f % anim.f_232255_() : f;
    }

    public static float getResetAmount(AnimationDefinition anim, long time) {
        if (time <= 160L) {
            return Mth.m_14036_((float)((float)time / 160.0f), (float)0.0f, (float)1.0f);
        }
        long time1 = (long)(anim.f_232255_() * 1000.0f - (float)time);
        return Mth.m_14036_((float)((float)time1 / 160.0f), (float)0.0f, (float)1.0f);
    }

    public static void lerpToDefault(ModelPart part, float amount, boolean pos, boolean rot) {
        PartPose initPose = part.m_233566_();
        if (pos) {
            part.f_104200_ = Mth.m_14179_((float)amount, (float)part.f_104200_, (float)initPose.f_171405_);
            part.f_104201_ = Mth.m_14179_((float)amount, (float)part.f_104201_, (float)initPose.f_171406_);
            part.f_104202_ = Mth.m_14179_((float)amount, (float)part.f_104202_, (float)initPose.f_171407_);
        }
        if (rot) {
            part.f_104203_ = Mth.m_14179_((float)amount, (float)part.f_104203_, (float)initPose.f_171408_);
            part.f_104204_ = Mth.m_14179_((float)amount, (float)part.f_104204_, (float)initPose.f_171409_);
            part.f_104205_ = Mth.m_14179_((float)amount, (float)part.f_104205_, (float)initPose.f_171410_);
        }
    }

    public static Optional<ModelPart> getPartFromString(PlayerModel<?> model, String s, boolean mirror) {
        ModelPart part = null;
        switch (s) {
            case "head": {
                part = model.f_102808_;
                break;
            }
            case "body": {
                part = model.f_102810_;
                break;
            }
            case "right_arm": {
                part = mirror ? model.f_102812_ : model.f_102811_;
                break;
            }
            case "left_arm": {
                part = mirror ? model.f_102811_ : model.f_102812_;
                break;
            }
            case "right_leg": {
                part = mirror ? model.f_102814_ : model.f_102813_;
                break;
            }
            case "left_leg": {
                part = mirror ? model.f_102813_ : model.f_102814_;
            }
        }
        return Optional.ofNullable(part);
    }

    public static enum TransformType {
        POSITION,
        ROTATION,
        SCALE;

    }
}

