/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.grinder;

import com.lance5057.butchercraft.workstations.grinder.GrinderBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrinderBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPEW = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)9.0, (double)12.0);
    protected static final VoxelShape SHAPEN = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)9.0, (double)16.0);

    public GrinderBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(3.0f, 4.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState p_152917_, BlockGetter p_152918_, BlockPos p_152919_, CollisionContext p_152920_) {
        switch ((Direction)p_152917_.m_61143_((Property)FACING)) {
            case NORTH: 
            case SOUTH: {
                return SHAPEN;
            }
        }
        return SHAPEW;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState blockState, Level world, @Nonnull BlockPos blockPos, @Nonnull Player playerEntity, @Nonnull InteractionHand hand, @Nonnull BlockHitResult blockRayTraceResult) {
        BlockEntity blockentity = world.m_7702_(blockPos);
        if (blockentity instanceof GrinderBlockEntity) {
            GrinderBlockEntity be = (GrinderBlockEntity)blockentity;
            if (playerEntity.m_6047_()) {
                be.extractItem(playerEntity);
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack = playerEntity.m_21120_(hand);
            if (!itemstack.m_41619_()) {
                playerEntity.m_21008_(hand, be.insertItem(itemstack));
                return InteractionResult.SUCCESS;
            }
            return be.grind(playerEntity, blockState);
        }
        return InteractionResult.PASS;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new GrinderBlockEntity(pPos, pState);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122428_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }
}

