/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.butcherblock;

import com.lance5057.butchercraft.ButchercraftBlockEntities;
import com.lance5057.butchercraft.ButchercraftMobEffects;
import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.armor.ApronItem;
import com.lance5057.butchercraft.armor.BootsItem;
import com.lance5057.butchercraft.armor.GlovesItem;
import com.lance5057.butchercraft.armor.MaskItem;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockBlock;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockContainer;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ButcherBlockBlockEntity
extends BlockEntity {
    private final LazyOptional<IItemHandlerModifiable> handler = LazyOptional.of(this::createHandler);
    public int progress;
    public int maxProgress;
    private Ingredient curTool;
    public int toolCount;
    public int stage = 0;

    public ButcherBlockBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ButchercraftBlockEntities.BUTCHER_BLOCK.get(), pPos, pState);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void setRecipe(Optional<ButcherBlockRecipe> r) {
        if (r.isPresent()) {
            this.setupStage(r.get(), 0);
        } else {
            this.zeroProgress();
        }
    }

    public void zeroProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.curTool = null;
        this.toolCount = 0;
        this.stage = 0;
    }

    public Optional<AnimatedRecipeItemUse> getCurrentTool() {
        return this.matchRecipe().map(ButcherBlockRecipe2 -> (AnimatedRecipeItemUse)ButcherBlockRecipe2.getRecipeToolsIn().get(this.stage));
    }

    protected void setupStage(ButcherBlockRecipe r, int i) {
        this.progress = 0;
        this.maxProgress = ((AnimatedRecipeItemUse)r.getRecipeToolsIn().get((int)i)).uses;
        this.curTool = ((AnimatedRecipeItemUse)r.getRecipeToolsIn().get((int)i)).tool;
        this.toolCount = ((AnimatedRecipeItemUse)r.getRecipeToolsIn().get((int)i)).count;
        this.stage = i;
    }

    boolean isFinalStage(ButcherBlockRecipe r) {
        int i = r.getRecipeToolsIn().size();
        return i - 1 <= this.stage;
    }

    private Optional<ButcherBlockRecipe> matchRecipe() {
        if (this.f_58857_ != null) {
            return this.f_58857_.m_7465_().m_44015_((RecipeType)ButchercraftRecipes.BUTCHER_BLOCK.get(), (Container)new ButcherBlockContainer(this.getInsertedItem()), this.f_58857_);
        }
        return Optional.empty();
    }

    private IItemHandlerModifiable createHandler() {
        return new ItemStackHandler(1){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                ButcherBlockBlockEntity.this.updateInventory();
                ButcherBlockBlockEntity.this.zeroProgress();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                boolean recipeWithInputExists = false;
                if (ButcherBlockBlockEntity.this.f_58857_ != null) {
                    recipeWithInputExists = ButcherBlockBlockEntity.this.f_58857_.m_7465_().m_44051_().stream().filter(recipe -> recipe instanceof ButcherBlockRecipe).map(recipe -> (ButcherBlockRecipe)recipe).anyMatch(ButcherBlockRecipe2 -> ButcherBlockRecipe2.getCarcassIn().test(stack));
                }
                return recipeWithInputExists && super.isItemValid(slot, stack);
            }
        };
    }

    public ItemStack getInsertedItem() {
        return this.handler.map(inventory -> inventory.getStackInSlot(0)).orElse(ItemStack.f_41583_);
    }

    public void extractInsertItem(Player playerEntity, InteractionHand hand) {
        this.handler.ifPresent(inventory -> {
            ItemStack held = playerEntity.m_21120_(hand);
            if (!held.m_41619_()) {
                this.insertItem((IItemHandler)inventory, held);
            } else {
                this.extractItem(playerEntity, (IItemHandler)inventory);
            }
        });
        this.updateInventory();
    }

    public void extractItem(Player playerEntity, IItemHandler inventory) {
        if (!inventory.getStackInSlot(0).m_41619_()) {
            ItemStack itemStack = inventory.extractItem(0, inventory.getStackInSlot(0).m_41613_(), false);
            playerEntity.m_36356_(itemStack);
        }
        this.updateInventory();
    }

    public void insertItem(IItemHandler inventory, ItemStack heldItem) {
        if (inventory.isItemValid(0, heldItem) && !inventory.insertItem(0, heldItem, true).equals(heldItem, false)) {
            int leftover = inventory.insertItem(0, heldItem.m_41777_(), false).m_41613_();
            heldItem.m_41764_(leftover);
        }
        this.updateInventory();
    }

    public boolean isEmpty() {
        return this.handler.map(inventory -> inventory.getStackInSlot(0).m_41619_()).orElse(false);
    }

    public void extractItem(Player playerEntity) {
        this.handler.ifPresent(inventory -> this.extractItem(playerEntity, (IItemHandler)inventory));
    }

    public void insertItem(ItemStack heldItem) {
        this.handler.ifPresent(inventory -> this.insertItem((IItemHandler)inventory, heldItem));
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ButcherBlockBlock.CARCASS_HOOKED, (Comparable)Boolean.valueOf(!this.getInsertedItem().m_41619_())), 3);
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ButcherBlockBlock.CARCASS_HOOKED, (Comparable)Boolean.valueOf(!this.getInsertedItem().m_41619_())), 3);
        }
    }

    public InteractionResult butcher(Player p, ItemStack butcheringTool) {
        Optional<ButcherBlockRecipe> recipeOptional = this.matchRecipe();
        if (recipeOptional.isPresent()) {
            ButcherBlockRecipe recipe = recipeOptional.get();
            if (this.curTool == null) {
                this.setupStage(recipe, this.stage);
            }
            if (this.curTool.test(butcheringTool)) {
                ItemStack boots;
                if (butcheringTool.m_41613_() >= this.toolCount) {
                    ++this.progress;
                    if (this.progress >= this.maxProgress) {
                        if (butcheringTool.m_41763_()) {
                            butcheringTool.m_41622_(1, (LivingEntity)p, x -> x.m_21166_(EquipmentSlot.MAINHAND));
                        } else {
                            butcheringTool.m_41764_(butcheringTool.m_41613_() - this.toolCount);
                        }
                        if (this.isFinalStage(recipe)) {
                            this.dropLoot((AnimatedRecipeItemUse)recipe.getRecipeToolsIn().get(this.stage), p);
                            this.finishRecipe();
                        } else {
                            this.dropLoot((AnimatedRecipeItemUse)recipe.getRecipeToolsIn().get(this.stage), p);
                            this.setupStage(recipe, this.stage + 1);
                        }
                        this.f_58857_.m_5594_(p, this.f_58858_, SoundEvents.f_12388_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        if (butcheringTool.m_41763_()) {
                            butcheringTool.m_41622_(1, (LivingEntity)p, x -> x.m_21166_(EquipmentSlot.MAINHAND));
                        } else {
                            butcheringTool.m_41764_(butcheringTool.m_41613_() - this.toolCount);
                        }
                        for (int i = 0; i < 1 + this.f_58857_.f_46441_.m_188503_(4); ++i) {
                            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_175823_, (double)((float)this.f_58858_.m_123341_() + 0.25f) + this.f_58857_.f_46441_.m_188500_() / 2.0, (double)((float)this.f_58858_.m_123342_() - 0.5f) - this.f_58857_.f_46441_.m_188500_(), (double)((float)this.f_58858_.m_123343_() + 0.25f) + this.f_58857_.f_46441_.m_188500_() / 2.0, 0.0, 0.0, 0.0);
                        }
                        this.f_58857_.m_5594_(p, this.f_58858_, SoundEvents.f_12470_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                if ((boots = p.m_150109_().m_36052_(0)).m_41720_() instanceof BootsItem) {
                    boots.m_41622_(1, (LivingEntity)p, x -> x.m_21166_(EquipmentSlot.FEET));
                } else {
                    p.m_7292_(new MobEffectInstance((MobEffect)ButchercraftMobEffects.BLOODTRAIL.get(), 3600, 0, false, false, true));
                }
                ItemStack apron = p.m_150109_().m_36052_(1);
                if (apron.m_41720_() instanceof ApronItem) {
                    apron.m_41622_(1, (LivingEntity)p, x -> x.m_21166_(EquipmentSlot.LEGS));
                } else {
                    p.m_7292_(new MobEffectInstance((MobEffect)ButchercraftMobEffects.BLOODY.get(), 3600, 0, false, false, true));
                }
                ItemStack gloves = p.m_150109_().m_36052_(2);
                if (gloves.m_41720_() instanceof GlovesItem) {
                    gloves.m_41622_(1, (LivingEntity)p, x -> x.m_21166_(EquipmentSlot.CHEST));
                } else {
                    p.m_7292_(new MobEffectInstance((MobEffect)ButchercraftMobEffects.DIRTY.get(), 3600, 0, false, false, true));
                }
                ItemStack mask = p.m_150109_().m_36052_(3);
                if (mask.m_41720_() instanceof MaskItem) {
                    mask.m_41622_(1, (LivingEntity)p, x -> x.m_21166_(EquipmentSlot.HEAD));
                } else {
                    p.m_7292_(new MobEffectInstance((MobEffect)ButchercraftMobEffects.STINKY.get(), 3600, 0, false, false, true));
                }
                this.updateInventory();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void dropLoot(AnimatedRecipeItemUse recipeToolsIn, Player player) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            LootParams pParams = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287239_(player.m_36336_() + (float)player.m_21205_().getEnchantmentLevel(Enchantments.f_44987_)).m_287235_(LootContextParamSets.f_81410_);
            player.m_20194_().m_278653_().m_278676_(recipeToolsIn.lootTable).m_287195_(pParams).forEach(itemStack -> this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 1.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f), itemStack, 0.0, 0.0, 0.0)));
        }
    }

    public void finishRecipe() {
        this.handler.ifPresent(h -> h.setStackInSlot(0, ItemStack.f_41583_));
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNBT(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.writeNBT(tag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.readNBT(tag);
    }

    void readNBT(CompoundTag nbt) {
        IItemHandler itemInteractionHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(this::createHandler);
        ((ItemStackHandler)itemInteractionHandler).deserializeNBT(nbt.m_128469_("inventory"));
        this.stage = nbt.m_128451_("stage");
    }

    CompoundTag writeNBT(CompoundTag tag) {
        IItemHandler itemInteractionHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(this::createHandler);
        tag.m_128365_("inventory", (Tag)((ItemStackHandler)itemInteractionHandler).serializeNBT());
        tag.m_128405_("stage", this.stage);
        return tag;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readNBT(nbt);
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeNBT(nbt);
    }
}

