/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.workstations.bases;

import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.bases.recipes.MultiToolRecipe;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class MultiToolRecipeStation<V extends MultiToolRecipe>
extends BlockEntity {
    protected final LazyOptional<IItemHandlerModifiable> InteractionHandler = LazyOptional.of(this::createInteractionHandler);
    public boolean recipeLocked = false;
    private int progress;
    private int maxProgress;
    private Ingredient curTool;
    public int toolCount;
    public int stage = 0;
    public final int width;
    public final int height;
    public final int numSlots;

    public MultiToolRecipeStation(int slots, int width, int height, BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.width = width;
        this.height = height;
        this.numSlots = slots;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.InteractionHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected abstract Optional<V> matchRecipe();

    public void setRecipe(Optional<V> r) {
        if (r.isPresent()) {
            this.setupStage((MultiToolRecipe)r.get(), 0);
        } else {
            this.zeroProgress();
        }
    }

    protected abstract IItemHandlerModifiable createInteractionHandler();

    public void zeroProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.curTool = null;
        this.toolCount = 0;
        this.stage = 0;
    }

    public AnimatedRecipeItemUse getCurrentTool() {
        Optional<V> currentRecipe = this.matchRecipe();
        if (currentRecipe.isPresent()) {
            return (AnimatedRecipeItemUse)((MultiToolRecipe)currentRecipe.get()).getToolList().get(this.stage);
        }
        return null;
    }

    public void updateInventory() {
        this.requestModelDataUpdate();
        this.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void setupStage(V r, int i) {
        this.progress = 0;
        this.maxProgress = ((AnimatedRecipeItemUse)((MultiToolRecipe)r).getToolList().get((int)i)).uses;
        this.curTool = ((AnimatedRecipeItemUse)((MultiToolRecipe)r).getToolList().get((int)i)).tool;
        this.toolCount = ((AnimatedRecipeItemUse)((MultiToolRecipe)r).getToolList().get((int)i)).count;
        this.stage = i;
    }

    boolean isFinalStage(V r) {
        int i = ((MultiToolRecipe)r).getToolList().size();
        return i - 1 <= this.stage;
    }

    public InteractionResult hammer(Player Player2, ItemStack hammer) {
        Optional<V> currentRecipe = this.matchRecipe();
        currentRecipe.ifPresent(r -> {
            if (this.curTool == null) {
                this.setupStage(r, this.stage);
            }
            if (this.curTool.test(hammer) && hammer.m_41613_() >= this.toolCount) {
                if (this.progress >= this.maxProgress) {
                    if (this.isFinalStage(r)) {
                        for (int i = 0; i < 5; ++i) {
                            this.addParticle();
                        }
                        this.f_58857_.m_5594_(Player2, this.f_58858_, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 0.0f);
                        if (hammer.m_41763_()) {
                            hammer.m_41622_(1, (LivingEntity)Player2, x -> x.m_21166_(EquipmentSlot.MAINHAND));
                        } else {
                            hammer.m_41764_(hammer.m_41613_() - this.toolCount);
                        }
                        this.finishRecipe(Player2, r);
                    } else {
                        this.setupStage(r, this.stage + 1);
                    }
                } else {
                    if (hammer.m_41763_()) {
                        hammer.m_41622_(1, (LivingEntity)Player2, x -> x.m_21166_(EquipmentSlot.MAINHAND));
                    } else {
                        hammer.m_41764_(hammer.m_41613_() - this.toolCount);
                    }
                    ++this.progress;
                }
            }
        });
        this.updateInventory();
        return InteractionResult.SUCCESS;
    }

    public abstract void addParticle();

    public abstract void finishRecipe(Player var1, V var2);

    protected void craft() {
        this.InteractionHandler.ifPresent(it -> {
            for (int i = 0; i < this.width * this.height; ++i) {
                ItemStack stack = it.getStackInSlot(i);
                stack.m_41764_(stack.m_41613_() - 1);
                it.setStackInSlot(i, stack);
            }
        });
    }

    protected ItemStack dropItemBelow(IItemHandler InteractionHandler, ItemStack insert) {
        for (int i = 0; i < InteractionHandler.getSlots(); ++i) {
            if (!(insert = InteractionHandler.insertItem(i, insert, false)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return insert;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNBT(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.writeNBT(tag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.readNBT(tag);
    }

    void readNBT(CompoundTag nbt) {
        IItemHandler itemInteractionHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(this::createInteractionHandler);
        ((ItemStackHandler)itemInteractionHandler).deserializeNBT(nbt.m_128469_("inventory"));
        this.stage = nbt.m_128451_("stage");
    }

    CompoundTag writeNBT(CompoundTag tag) {
        IItemHandler itemInteractionHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(this::createInteractionHandler);
        tag.m_128365_("inventory", (Tag)((ItemStackHandler)itemInteractionHandler).serializeNBT());
        tag.m_128405_("stage", this.stage);
        return tag;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readNBT(nbt);
    }

    @Nonnull
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeNBT(nbt);
    }
}

