/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.items;

import com.lance5057.butchercraft.ButchercraftMobEffects;
import com.lance5057.butchercraft.items.KnifeItem;
import com.lance5057.butchercraft.tags.ButchercraftEntityTags;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.registries.ForgeRegistries;

public class ButcherKnifeItem
extends KnifeItem {
    public ButcherKnifeItem(Item.Properties builderIn) {
        super(builderIn);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.m_21023_((MobEffect)ButchercraftMobEffects.BLOODLUST.get())) {
            return InteractionResult.FAIL;
        }
        if (entity instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)entity;
            if (entity.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_());
            if (target.isShearable(stack, entity.m_9236_(), pos)) {
                List drops = target.onSheared(player, stack, entity.m_9236_(), pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.m_5552_(d, 1.0f);
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
            }
        }
        if (player.m_20194_() != null && entity.m_6095_().m_204039_(ButchercraftEntityTags.CARCASSES) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!this.specialCases(player, mob)) {
                ResourceLocation lootTableLocation = new ResourceLocation("butchercraft", "butcher_knife/" + ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).m_135815_());
                LootTable lootTable = player.m_20194_().m_278653_().m_278676_(lootTableLocation);
                if (lootTable != LootTable.f_79105_) {
                    this.killAndDrop(player, lootTableLocation, mob);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void killAndDrop(Player player, ResourceLocation lootTableLocation, Mob mob) {
        player.m_9236_().m_5594_(null, mob.m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        mob.f_21355_ = lootTableLocation;
        mob.m_6598_(player);
        mob.m_6469_(player.m_269291_().m_269075_(player), 99999.0f);
    }

    boolean specialCases(Player player, Mob mob) {
        if (mob instanceof Rabbit) {
            Rabbit r = (Rabbit)mob;
            switch (r.m_28554_()) {
                case BLACK: {
                    this.rabbitDrop(player, mob, "_black");
                    return true;
                }
                case BROWN: {
                    this.rabbitDrop(player, mob, "_brown");
                    return true;
                }
                case GOLD: {
                    this.rabbitDrop(player, mob, "_gold");
                    return true;
                }
                case SALT: {
                    this.rabbitDrop(player, mob, "_salt");
                    return true;
                }
                case WHITE: {
                    this.rabbitDrop(player, mob, "_white");
                    return true;
                }
                case WHITE_SPLOTCHED: {
                    this.rabbitDrop(player, mob, "_splotched");
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void rabbitDrop(Player player, Mob mob, String type) {
        ResourceLocation lootTableLocation = new ResourceLocation("butchercraft", "butcher_knife/" + ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()).m_135815_() + type);
        LootTable lootTable = player.m_20194_().m_278653_().m_278676_(lootTableLocation);
        if (lootTable != LootTable.f_79105_) {
            this.killAndDrop(player, lootTableLocation, mob);
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"butchercraft.butcherknife.rightclick")).m_130940_(ChatFormatting.DARK_PURPLE));
    }
}

