/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.integration.jei.categories;

import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.butcherblock.ButcherBlockRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ButcherBlockRecipeCategory
implements IRecipeCategory<ButcherBlockRecipe> {
    public static final RecipeType<ButcherBlockRecipe> TYPE = RecipeType.create((String)"butchercraft", (String)"butcher_block", ButcherBlockRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public ButcherBlockRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("butchercraft", "textures/gui/jei.png"), 108, 78, 144, 144);
        this.localizedName = Component.m_237115_((String)"Butchercraft.jei.butcherblock");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ButchercraftItems.BUTCHER_BLOCK_BLOCK_ITEM.get()));
    }

    public RecipeType<ButcherBlockRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ButcherBlockRecipe recipe, IFocusGroup focuses) {
        int count = recipe.getRecipeToolsIn().size();
        int offset = 2;
        int width = 16 + offset;
        int placementH = 0;
        int height = 16 + offset;
        int placementW = 0;
        int c = 0;
        builder.addSlot(RecipeIngredientRole.INPUT, this.getBackground().getWidth() / 2 - 8, 40).addIngredients(recipe.getCarcassIn());
        for (AnimatedRecipeItemUse a : recipe.getRecipeToolsIn()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 1 + placementW, 1 + placementH).addIngredients(a.tool);
            placementW += width;
            if (++c <= 7) continue;
            placementH += height;
            placementW = 0;
            c = 0;
        }
        c = 0;
        placementW = 0;
        placementH = 0;
        for (Ingredient i : recipe.getDummyList()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + placementW, 73 + placementH + 18).addIngredients(i);
            placementW += width;
            if (++c <= 7) continue;
            placementH += height;
            placementW = 0;
            c = 0;
        }
    }
}

