/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.data.builders.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lance5057.butchercraft.ButchercraftRecipeSerializers;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipeSerializer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class GrinderRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final Ingredient ingredient;
    private final int ingredientCount;
    private final Ingredient attachment;
    private final int resultCount;
    private final int grinds;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final GrinderRecipeSerializer serializer;

    private GrinderRecipeBuilder(RecipeCategory pCategory, ItemLike pResult, Ingredient pIngredient, Ingredient attachment, int pGrind, int count, GrinderRecipeSerializer serializer, int ingredientCount) {
        this.category = pCategory;
        this.result = pResult.m_5456_();
        this.ingredient = pIngredient;
        this.ingredientCount = ingredientCount;
        this.attachment = attachment;
        this.resultCount = count;
        this.grinds = pGrind;
        this.serializer = serializer;
    }

    public static GrinderRecipeBuilder grind(Ingredient pIngredient, RecipeCategory pCategory, int ingredientCount, Ingredient attachment, ItemLike pResult, int grinds, int resultCount) {
        return new GrinderRecipeBuilder(pCategory, pResult, pIngredient, attachment, grinds, resultCount, (GrinderRecipeSerializer)ButchercraftRecipeSerializers.GRINDER_SERIALIZER.get(), ingredientCount);
    }

    public GrinderRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public GrinderRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_176498_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)this.result);
        this.m_176500_(pFinishedRecipeConsumer, "butchercraft:mortar/" + location.m_135815_());
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        ResourceLocation r = new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + this.category.m_247710_() + "/" + pRecipeId.m_135815_());
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.ingredient, this.attachment, this.result, this.grinds, this.resultCount, this.advancement, r, this.serializer, this.ingredientCount));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final int ingredientCount;
        private final Ingredient attachment;
        private final Item result;
        private final int resultCount;
        private final int grinds;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final GrinderRecipeSerializer serializer;

        public Result(ResourceLocation pId, String pGroup, Ingredient pIngredient, Ingredient attachment, Item pResult, int pGrinds, int pResultCount, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, GrinderRecipeSerializer pSerializer, int ingredientCount) {
            this.id = pId;
            this.group = pGroup;
            this.ingredient = pIngredient;
            this.ingredientCount = ingredientCount;
            this.attachment = attachment;
            this.result = pResult;
            this.resultCount = pResultCount;
            this.grinds = pGrinds;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
            this.serializer = pSerializer;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.addProperty("ingredientCount", (Number)this.ingredientCount);
            pJson.add("attachment", this.attachment.m_43942_());
            JsonObject objectResult = new JsonObject();
            objectResult.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.resultCount > 1) {
                objectResult.addProperty("count", (Number)this.resultCount);
            }
            pJson.add("result", (JsonElement)objectResult);
            pJson.addProperty("grinds", (Number)this.grinds);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

