/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.data.builders.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lance5057.butchercraft.ButchercraftRecipeSerializers;
import com.lance5057.butchercraft.client.BlacklistedModel;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class ButcherBlockRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final List<AnimatedRecipeItemUse> tools = NonNullList.m_122779_();
    private final List<Ingredient> jei = NonNullList.m_122779_();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group;

    public ButcherBlockRecipeBuilder(Item carcassIn) {
        this.result = carcassIn;
    }

    public static ButcherBlockRecipeBuilder shapedRecipe(Item resultIn) {
        return new ButcherBlockRecipeBuilder(resultIn);
    }

    public ButcherBlockRecipeBuilder tool(Ingredient tool, int count, int uses, boolean damage, ResourceLocation table, BlacklistedModel ... model) {
        this.tools.add(new AnimatedRecipeItemUse(uses, tool, count, damage, table, model));
        return this;
    }

    public ButcherBlockRecipeBuilder tool(Ingredient tool, int uses, boolean damage, ResourceLocation table, BlacklistedModel ... model) {
        this.tools.add(new AnimatedRecipeItemUse(uses, tool, 1, damage, table, model));
        return this;
    }

    public ButcherBlockRecipeBuilder JEIIngredient(Ingredient i) {
        this.jei.add(i);
        return this;
    }

    private void validate(ResourceLocation id) {
        if (this.tools.isEmpty()) {
            throw new IllegalStateException("No toolset is defined for shaped recipe %s!".formatted(id));
        }
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancementBuilder.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumerIn, ResourceLocation pRecipeId) {
        this.validate(pRecipeId);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        consumerIn.accept(new Result(pRecipeId, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.result}), this.group == null ? "" : this.group, this.tools, this.jei, this.advancementBuilder, new ResourceLocation(pRecipeId.m_135827_(), "recipes/meat_hook/" + pRecipeId.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient carcass;
        private final String group;
        private final List<AnimatedRecipeItemUse> tools;
        private final List<Ingredient> JEI;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation idIn, Ingredient carcassIn, String groupIn, List<AnimatedRecipeItemUse> toolsIn, List<Ingredient> JEI, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.carcass = carcassIn;
            this.group = groupIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
            this.tools = toolsIn;
            this.JEI = JEI;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("group", this.group);
            JsonArray stepArray = new JsonArray();
            this.tools.stream().map(AnimatedRecipeItemUse::addProperty).forEach(arg_0 -> ((JsonArray)stepArray).add(arg_0));
            json.add("tools", (JsonElement)stepArray);
            json.add("carcass", this.carcass.m_43942_());
            JsonArray jei = new JsonArray();
            this.JEI.stream().forEach(i -> jei.add(i.m_43942_()));
            json.add("jei", (JsonElement)jei);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ButchercraftRecipeSerializers.BUTCHER_BLOCK_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

