/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.client.rendering.animation.floats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lance5057.butchercraft.client.rendering.animation.floats.AnimatedFloatVector3;
import net.minecraft.network.FriendlyByteBuf;

public class AnimationFloatTransform {
    AnimatedFloatVector3 loc;
    AnimatedFloatVector3 scale;
    AnimatedFloatVector3 rot;
    public static AnimationFloatTransform ZERO = new AnimationFloatTransform(AnimatedFloatVector3.ZERO, AnimatedFloatVector3.ZERO, AnimatedFloatVector3.ZERO);
    public static AnimationFloatTransform ONE = new AnimationFloatTransform(AnimatedFloatVector3.ONE, AnimatedFloatVector3.ONE, AnimatedFloatVector3.ONE);

    public AnimationFloatTransform() {
        this.loc = AnimatedFloatVector3.ZERO;
        this.rot = AnimatedFloatVector3.ZERO;
        this.scale = AnimatedFloatVector3.ONE;
    }

    public AnimationFloatTransform(AnimatedFloatVector3 l, AnimatedFloatVector3 s, AnimatedFloatVector3 r) {
        this.loc = l;
        this.scale = s;
        this.rot = r;
    }

    public void animate(float time) {
        this.loc.animate(time);
        this.scale.animate(time);
        this.rot.animate(time);
    }

    public AnimationFloatTransform setLocation(AnimatedFloatVector3 in) {
        this.loc = in;
        return this;
    }

    public AnimationFloatTransform setRotation(AnimatedFloatVector3 in) {
        this.rot = in;
        return this;
    }

    public AnimationFloatTransform setScale(AnimatedFloatVector3 in) {
        this.scale = in;
        return this;
    }

    public AnimatedFloatVector3 getLocation() {
        return this.loc;
    }

    public AnimatedFloatVector3 getScale() {
        return this.scale;
    }

    public AnimatedFloatVector3 getRotation() {
        return this.rot;
    }

    public static AnimationFloatTransform read(JsonObject j) {
        AnimatedFloatVector3 location = AnimatedFloatVector3.read(j.get("location").getAsJsonObject());
        AnimatedFloatVector3 rotation = AnimatedFloatVector3.read(j.get("rotation").getAsJsonObject());
        AnimatedFloatVector3 scale = AnimatedFloatVector3.read(j.get("scale").getAsJsonObject());
        return new AnimationFloatTransform(location, scale, rotation);
    }

    public static AnimationFloatTransform read(FriendlyByteBuf buffer) {
        AnimatedFloatVector3 l = AnimatedFloatVector3.read(buffer);
        AnimatedFloatVector3 r = AnimatedFloatVector3.read(buffer);
        AnimatedFloatVector3 s = AnimatedFloatVector3.read(buffer);
        return new AnimationFloatTransform(l, s, r);
    }

    public static void write(AnimationFloatTransform af, FriendlyByteBuf buffer) {
        AnimatedFloatVector3.write(af.loc, buffer);
        AnimatedFloatVector3.write(af.rot, buffer);
        AnimatedFloatVector3.write(af.scale, buffer);
    }

    public static JsonObject addProperty(AnimationFloatTransform af) {
        JsonObject jo = new JsonObject();
        jo.add("location", (JsonElement)AnimatedFloatVector3.addProperty(af.loc));
        jo.add("rotation", (JsonElement)AnimatedFloatVector3.addProperty(af.rot));
        jo.add("scale", (JsonElement)AnimatedFloatVector3.addProperty(af.scale));
        return jo;
    }
}

