/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.client.rendering.animation.floats;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;

public class AnimatedFloat {
    float i;
    float iMax;
    float iMin;
    float offset;
    float speed;
    boolean add = true;
    boolean loop = false;
    boolean pingpong = false;
    public static AnimatedFloat ZERO = new AnimatedFloat(0.0f, 0.0f, 0.0f);
    public static AnimatedFloat ONE = new AnimatedFloat(1.0f, 1.0f, 1.0f);

    public AnimatedFloat(float iMax) {
        this(-iMax, iMax, 1.0f);
    }

    public AnimatedFloat(float iMax, float speed) {
        this(-iMax, iMax, speed);
    }

    public AnimatedFloat(float iMin, float iMax, float speed) {
        this.iMin = iMin;
        this.iMax = iMax;
        this.speed = speed;
    }

    public AnimatedFloat(float iMin, float iMax, float offset, float speed, boolean loop, boolean pingpong) {
        this.iMin = iMin;
        this.iMax = iMax;
        this.speed = speed;
        this.offset = offset;
        this.loop = loop;
        this.pingpong = pingpong;
    }

    public float animate(float time) {
        float t2;
        float mod = this.iMax - this.iMin;
        if (mod == 0.0f) {
            return 0.0f;
        }
        float t = time * this.speed % mod;
        if (this.pingpong && (t2 = time * this.speed % (mod * 2.0f)) >= mod) {
            t = mod - t;
        }
        if (!this.loop && t + this.speed >= this.iMax) {
            this.speed = 0.0f;
        }
        if (this.speed == 0.0f) {
            return this.iMax;
        }
        return t + this.iMin;
    }

    public float getMax() {
        return this.iMax;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setMax(float m) {
        this.iMax = m;
    }

    public void setMin(float m) {
        this.iMin = m;
    }

    public void setSpeed(float s) {
        this.speed = s;
    }

    public static AnimatedFloat read(JsonObject j) {
        float min = j.get("min") != null ? j.get("min").getAsFloat() : 0.0f;
        float max = j.get("max") != null ? j.get("max").getAsFloat() : 0.0f;
        float offset = j.get("offset") != null ? j.get("offset").getAsFloat() : 0.0f;
        float speed = j.get("speed") != null ? j.get("speed").getAsFloat() : 0.0f;
        boolean loop = j.get("loop") != null ? j.get("loop").getAsBoolean() : false;
        boolean pingpong = j.get("pingpong") != null ? j.get("pingpong").getAsBoolean() : false;
        return new AnimatedFloat(min, max, offset, speed, loop, pingpong);
    }

    public static AnimatedFloat read(FriendlyByteBuf buffer) {
        float min = buffer.readFloat();
        float max = buffer.readFloat();
        float offset = buffer.readFloat();
        float speed = buffer.readFloat();
        boolean loop = buffer.readBoolean();
        boolean pingpong = buffer.readBoolean();
        return new AnimatedFloat(min, max, offset, speed, loop, pingpong);
    }

    public static void write(AnimatedFloat af, FriendlyByteBuf buffer) {
        buffer.writeFloat(af.iMin);
        buffer.writeFloat(af.iMax);
        buffer.writeFloat(af.offset);
        buffer.writeFloat(af.speed);
        buffer.writeBoolean(af.loop);
        buffer.writeBoolean(af.pingpong);
    }

    public static JsonObject addProperty(AnimatedFloat af) {
        JsonObject jo = new JsonObject();
        if (af.iMin != 0.0f) {
            jo.addProperty("min", (Number)Float.valueOf(af.iMin));
        }
        if (af.iMax != 0.0f) {
            jo.addProperty("max", (Number)Float.valueOf(af.iMax));
        }
        if (af.offset != 0.0f) {
            jo.addProperty("offset", (Number)Float.valueOf(af.offset));
        }
        if (af.speed != 0.0f) {
            jo.addProperty("speed", (Number)Float.valueOf(af.speed));
        }
        if (af.loop) {
            jo.addProperty("loop", Boolean.valueOf(af.loop));
        }
        if (af.pingpong) {
            jo.addProperty("pingpong", Boolean.valueOf(af.pingpong));
        }
        return jo;
    }
}

