/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft.client.rendering;

import com.lance5057.butchercraft.client.BlacklistedModel;
import com.lance5057.butchercraft.client.rendering.animation.floats.AnimationFloatTransform;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.renderable.BakedModelRenderable;
import net.minecraftforge.client.model.renderable.IRenderable;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;

public class RenderUtil {
    public static Quaternionf createQuaternion(float x, float y, float z, boolean degrees) {
        if (degrees) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        float f = Mth.m_14031_((float)(0.5f * x));
        float g = Mth.m_14089_((float)(0.5f * x));
        float h = Mth.m_14031_((float)(0.5f * y));
        float i = Mth.m_14089_((float)(0.5f * y));
        float j = Mth.m_14031_((float)(0.5f * z));
        float k = Mth.m_14089_((float)(0.5f * z));
        return new Quaternionf(f * i * k + g * h * j, g * h * k - f * i * j, f * h * k + g * i * j, g * i * k - f * h * j);
    }

    public static void loadModel(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlacklistedModel model, float timer) {
        if (model.isBlock) {
            IRenderable bm = BakedModelRenderable.of((ResourceLocation)model.rc).withModelDataContext();
            RenderUtil.blockModel(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, (IRenderable<ModelData>)bm, model.blacklist, model.transform, timer);
        } else {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(model.rc);
            RenderUtil.itemModel(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, item, model.blacklist, model.transform, timer);
        }
    }

    public static void blockModel(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, IRenderable<ModelData> bm, List<Integer> blacklist, AnimationFloatTransform transform, float timer) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(transform.getLocation().getX().animate(timer) / 16.0f, transform.getLocation().getY().animate(timer) / 16.0f, transform.getLocation().getZ().animate(timer) / 16.0f);
        matrixStackIn.m_252781_(RenderUtil.createQuaternion(transform.getRotation().getX().animate(timer), transform.getRotation().getY().animate(timer), transform.getRotation().getZ().animate(timer), true));
        matrixStackIn.m_85841_(1.0f + transform.getScale().getX().animate(timer), 1.0f + transform.getScale().getY().animate(timer), 1.0f + transform.getScale().getZ().animate(timer));
        bm.render(matrixStackIn, bufferIn, texture -> RenderType.m_110473_((ResourceLocation)texture), combinedLightIn, combinedOverlayIn, timer, (Object)ModelData.EMPTY);
        matrixStackIn.m_85849_();
    }

    public static void itemModel(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, Item item, List<Integer> blacklist, AnimationFloatTransform transform, float timer) {
        matrixStackIn.m_85836_();
        ItemStack stack = new ItemStack((ItemLike)item);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel bakedmodel = itemRenderer.m_174264_(stack, null, null, 0);
        matrixStackIn.m_252880_(transform.getLocation().getX().getOffset() + transform.getLocation().getX().animate(timer) / 16.0f, transform.getLocation().getY().getOffset() + transform.getLocation().getY().animate(timer) / 16.0f, transform.getLocation().getZ().getOffset() + transform.getLocation().getZ().animate(timer) / 16.0f);
        matrixStackIn.m_252781_(RenderUtil.createQuaternion(transform.getRotation().getX().getOffset() + transform.getRotation().getX().animate(timer), transform.getRotation().getY().getOffset() + transform.getRotation().getY().animate(timer), transform.getRotation().getZ().getOffset() + transform.getRotation().getZ().animate(timer), true));
        matrixStackIn.m_85841_(transform.getScale().getX().animate(timer), transform.getScale().getY().animate(timer), transform.getScale().getZ().animate(timer));
        itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedmodel);
        matrixStackIn.m_85849_();
    }
}

