/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.butchercraft;

import com.lance5057.butchercraft.ButchercraftConfig;
import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.ButchercraftMobEffects;
import com.lance5057.butchercraft.armor.models.ApronModel;
import com.lance5057.butchercraft.armor.models.BootsModel;
import com.lance5057.butchercraft.armor.models.BunnyEarsModel;
import com.lance5057.butchercraft.armor.models.BunnyTailModel;
import com.lance5057.butchercraft.armor.models.ChickenMaskModel;
import com.lance5057.butchercraft.armor.models.CowHoodModel;
import com.lance5057.butchercraft.armor.models.GlovesModel;
import com.lance5057.butchercraft.armor.models.GoatHoodModel;
import com.lance5057.butchercraft.armor.models.MaskModel;
import com.lance5057.butchercraft.armor.models.PaperHatModel;
import com.lance5057.butchercraft.armor.models.PigHoodModel;
import com.lance5057.butchercraft.armor.models.SheepHoodModel;
import com.lance5057.butchercraft.capabilities.AnimalCare;
import com.lance5057.butchercraft.capabilities.AnimalCareProvider;
import com.lance5057.butchercraft.client.block_models.ChickenHeadModel;
import com.lance5057.butchercraft.client.block_models.ChickenSkullHeadModel;
import com.lance5057.butchercraft.client.block_models.CowHeadModel;
import com.lance5057.butchercraft.client.block_models.CowSkullHeadModel;
import com.lance5057.butchercraft.client.block_models.GoatHeadModel;
import com.lance5057.butchercraft.client.block_models.GoatSkullHeadModel;
import com.lance5057.butchercraft.client.block_models.PigHeadModel;
import com.lance5057.butchercraft.client.block_models.PigSkullHeadModel;
import com.lance5057.butchercraft.client.block_models.RabbitHeadModel;
import com.lance5057.butchercraft.client.block_models.RabbitSkullHeadModel;
import com.lance5057.butchercraft.client.block_models.SheepHeadModel;
import com.lance5057.butchercraft.client.block_models.SheepSkullHeadModel;
import com.lance5057.butchercraft.entity.ai.AngryAnimalAttackGoal;
import com.lance5057.butchercraft.entity.ai.AngryAnimalTargetGoal;
import com.lance5057.butchercraft.entity.ai.ClothingTemptGoal;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="butchercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ButchercraftModEvents {
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(AnimalCare.class);
    }

    public static void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Cow && !((Entity)event.getObject()).getCapability(AnimalCareProvider.CARE).isPresent()) {
            event.addCapability(new ResourceLocation("butchercraft", "animalcare"), (ICapabilityProvider)new AnimalCareProvider());
        }
    }

    public static void breedEvent(BabyEntitySpawnEvent event) {
        Level level = event.getChild().m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (event.getChild() instanceof Cow) {
                Cow baby = (Cow)event.getChild();
                Cow pA = (Cow)event.getParentA();
                Cow pB = (Cow)event.getParentB();
                baby.m_146762_((int)(-24000.0 * (Double)ButchercraftConfig.AGE_MULTIPLIER.get()));
                pA.m_146762_((int)(6000.0 * (Double)ButchercraftConfig.BREEDING_MULTIPLIER.get()));
                pB.m_146762_((int)(6000.0 * (Double)ButchercraftConfig.BREEDING_MULTIPLIER.get()));
                float pAN = pA.getCapability(AnimalCareProvider.CARE).map(i -> Float.valueOf(i.getNutrition())).orElse(Float.valueOf(((Double)ButchercraftConfig.WILDLIFE_NUTRITION.get()).floatValue())).floatValue();
                float pBN = pB.getCapability(AnimalCareProvider.CARE).map(i -> Float.valueOf(i.getNutrition())).orElse(Float.valueOf(((Double)ButchercraftConfig.WILDLIFE_NUTRITION.get()).floatValue())).floatValue();
                if (pAN + pBN >= 2.0f) {
                    baby.getCapability(AnimalCareProvider.CARE).ifPresent(i -> i.setNutrition(0.9f));
                    Cow baby2 = (Cow)baby.m_6095_().m_20592_(server, null, event.getCausedByPlayer(), pA.m_20183_(), MobSpawnType.BREEDING, true, false);
                    baby2.m_6863_(true);
                    baby2.getCapability(AnimalCareProvider.CARE).ifPresent(i -> i.setNutrition(0.9f));
                } else {
                    float bred = Math.max(pAN, pBN) + Math.min(pAN, pBN) / 2.0f;
                    baby.getCapability(AnimalCareProvider.CARE).ifPresent(i -> i.setNutrition(bred));
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PaperHatModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)PaperHatModel.createLayer(LayerDefinitions.f_171107_), (int)32, (int)32));
        event.registerLayerDefinition(ApronModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)ApronModel.createLayer(LayerDefinitions.f_171106_), (int)32, (int)32));
        event.registerLayerDefinition(GlovesModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)GlovesModel.createLayer(LayerDefinitions.f_171106_), (int)32, (int)32));
        event.registerLayerDefinition(BootsModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)BootsModel.createLayer(LayerDefinitions.f_171106_), (int)32, (int)32));
        event.registerLayerDefinition(MaskModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)MaskModel.createLayer(LayerDefinitions.f_171106_), (int)32, (int)32));
        event.registerLayerDefinition(BunnyEarsModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)BunnyEarsModel.createLayer(LayerDefinitions.f_171107_), (int)16, (int)16));
        event.registerLayerDefinition(BunnyTailModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)BunnyTailModel.createLayer(LayerDefinitions.f_171107_), (int)16, (int)16));
        event.registerLayerDefinition(PigHoodModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)PigHoodModel.createLayer(LayerDefinitions.f_171106_), (int)64, (int)64));
        event.registerLayerDefinition(GoatHoodModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)GoatHoodModel.createLayer(LayerDefinitions.f_171106_), (int)64, (int)64));
        event.registerLayerDefinition(CowHoodModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)CowHoodModel.createLayer(LayerDefinitions.f_171106_), (int)64, (int)64));
        event.registerLayerDefinition(SheepHoodModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)SheepHoodModel.createLayer(LayerDefinitions.f_171106_), (int)64, (int)64));
        event.registerLayerDefinition(ChickenMaskModel.LAYER_LOCATION, () -> LayerDefinition.m_171565_((MeshDefinition)ChickenMaskModel.createLayer(LayerDefinitions.f_171106_), (int)64, (int)32));
        event.registerLayerDefinition(CowHeadModel.LAYER_LOCATION, () -> CowHeadModel.createBodyLayer());
        event.registerLayerDefinition(ChickenHeadModel.LAYER_LOCATION, () -> ChickenHeadModel.createBodyLayer());
        event.registerLayerDefinition(SheepHeadModel.LAYER_LOCATION, () -> SheepHeadModel.createBodyLayer());
        event.registerLayerDefinition(PigHeadModel.LAYER_LOCATION, () -> PigHeadModel.createBodyLayer());
        event.registerLayerDefinition(GoatHeadModel.LAYER_LOCATION, () -> GoatHeadModel.createBodyLayer());
        event.registerLayerDefinition(RabbitHeadModel.LAYER_LOCATION, () -> RabbitHeadModel.createBodyLayer());
        event.registerLayerDefinition(CowSkullHeadModel.LAYER_LOCATION, () -> CowSkullHeadModel.createBodyLayer());
        event.registerLayerDefinition(SheepSkullHeadModel.LAYER_LOCATION, () -> SheepSkullHeadModel.createBodyLayer());
        event.registerLayerDefinition(PigSkullHeadModel.LAYER_LOCATION, () -> PigSkullHeadModel.createBodyLayer());
        event.registerLayerDefinition(ChickenSkullHeadModel.LAYER_LOCATION, () -> ChickenSkullHeadModel.createBodyLayer());
        event.registerLayerDefinition(GoatSkullHeadModel.LAYER_LOCATION, () -> GoatSkullHeadModel.createBodyLayer());
        event.registerLayerDefinition(RabbitSkullHeadModel.LAYER_LOCATION, () -> RabbitSkullHeadModel.createBodyLayer());
    }

    public static void cancelInteractions(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof Villager) {
            Villager v = (Villager)entity;
            if (event.getEntity().m_21023_((MobEffect)ButchercraftMobEffects.STINKY.get()) || event.getEntity().m_21023_((MobEffect)ButchercraftMobEffects.BLOODY.get())) {
                v.m_35319_(40);
                if (!v.m_9236_().m_5776_()) {
                    v.m_5496_(SoundEvents.f_12507_, 1.0f, v.m_6100_());
                }
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    public static void cancelEat(LivingEntityUseItemEvent.Start event) {
        ItemStack stack;
        if (event.getEntity().m_21023_((MobEffect)ButchercraftMobEffects.STINKY.get()) && ((stack = event.getItem()).getFoodProperties(event.getEntity()) != null || stack.m_41720_() instanceof PotionItem || stack.m_41720_() instanceof MilkBucketItem)) {
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100));
            event.setCanceled(true);
        }
    }

    public static void dirtyHands(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack;
        if (event.getEntity().m_21023_((MobEffect)ButchercraftMobEffects.DIRTY.get()) && ((stack = event.getItem()).getFoodProperties(event.getEntity()) != null || stack.m_41720_() instanceof PotionItem || stack.m_41720_() instanceof MilkBucketItem)) {
            switch (event.getEntity().m_9236_().f_46441_.m_188503_(3)) {
                case 0: {
                    event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600));
                }
                case 1: {
                    event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600));
                }
            }
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600));
            event.setCanceled(true);
        }
    }

    public static void buffZombie(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Zombie) {
            Zombie z = (Zombie)entity;
            if (event.getEntity().m_21023_((MobEffect)ButchercraftMobEffects.BLOODY.get())) {
                z.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 0));
                z.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 0));
            }
        }
    }

    public static void EntityJoined(EntityJoinLevelEvent event) {
        Pig p;
        Entity e = event.getEntity();
        if (e instanceof Pig) {
            p = (Pig)e;
            p.f_21345_.m_25352_(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.PIG_HOOD.get()}), false));
            p.f_21346_.m_25352_(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.f_21345_.m_25352_(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Cow) {
            p = (Cow)e;
            p.f_21345_.m_25352_(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.COW_HOOD.get()}), false));
            p.f_21346_.m_25352_(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.f_21345_.m_25352_(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Sheep) {
            p = (Sheep)e;
            p.f_21345_.m_25352_(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.SHEEP_HOOD.get()}), false));
            p.f_21346_.m_25352_(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.f_21345_.m_25352_(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Goat) {
            p = (Goat)e;
            p.f_21345_.m_25352_(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.GOAT_HOOD.get()}), false));
            p.f_21346_.m_25352_(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.f_21345_.m_25352_(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Chicken) {
            p = (Chicken)e;
            p.f_21345_.m_25352_(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.CHICKEN_MASK.get()}), false));
            p.f_21346_.m_25352_(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
            p.f_21345_.m_25352_(2, (Goal)new AngryAnimalAttackGoal((Animal)p, 1.0, false));
        }
        if (e instanceof Rabbit) {
            p = (Rabbit)e;
            p.f_21345_.m_25352_(4, (Goal)new ClothingTemptGoal((PathfinderMob)p, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ButchercraftItems.BLACK_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.BROWN_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.GOLD_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.SALT_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.WHITE_BUNNY_EARS.get(), (ItemLike)ButchercraftItems.BLACK_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.BROWN_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.GOLD_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.SALT_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.SPLOTCHED_BUNNY_TAIL.get(), (ItemLike)ButchercraftItems.WHITE_BUNNY_TAIL.get()}), false));
            p.f_21346_.m_25352_(2, (Goal)new AngryAnimalTargetGoal((Animal)p));
        }
    }

    @SubscribeEvent
    public static void existingEntityAttributes(EntityAttributeModificationEvent event) {
        if (!event.has(EntityType.f_20510_, Attributes.f_22281_)) {
            event.add(EntityType.f_20510_, Attributes.f_22281_, 3.0);
        }
        if (!event.has(EntityType.f_20557_, Attributes.f_22281_)) {
            event.add(EntityType.f_20557_, Attributes.f_22281_, 4.0);
        }
        if (!event.has(EntityType.f_20520_, Attributes.f_22281_)) {
            event.add(EntityType.f_20520_, Attributes.f_22281_, 3.0);
        }
        if (!event.has(EntityType.f_147035_, Attributes.f_22281_)) {
            event.add(EntityType.f_147035_, Attributes.f_22281_, 4.0);
        }
        if (!event.has(EntityType.f_20517_, Attributes.f_22281_)) {
            event.add(EntityType.f_20517_, Attributes.f_22281_, 1.0);
        }
        if (!event.has(EntityType.f_20555_, Attributes.f_22281_)) {
            event.add(EntityType.f_20555_, Attributes.f_22281_, 2.0);
        }
    }

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.m_246326_(() -> ButchercraftItems.COW_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.COW_SKULL_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.SHEEP_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.SHEEP_SKULL_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.PIG_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.PIG_SKULL_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.GOAT_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.GOAT_SKULL_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.CHICKEN_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.CHICKEN_SKULL_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.RABBIT_BROWN_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.RABBIT_BLACK_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.RABBIT_GOLD_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.RABBIT_SALT_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.RABBIT_SPLOTCHED_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.RABBIT_WHITE_HEAD_ITEM.get());
            event.m_246326_(() -> ButchercraftItems.RABBIT_SKULL_HEAD_ITEM.get());
        }
        if (event.getTabKey() == ButchercraftItems.BUTCHER_TAB.getKey()) {
            ButchercraftItems.ITEMS.getEntries().forEach(obj -> event.m_246326_(() -> ((RegistryObject)obj).get()));
        }
    }
}

