/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPodium;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdatePodium {
    public long blockPos;
    public ItemStack heldStack;

    public MessageUpdatePodium(long blockPos, ItemStack heldStack) {
        this.blockPos = blockPos;
        this.heldStack = heldStack;
    }

    public MessageUpdatePodium() {
    }

    public static MessageUpdatePodium read(FriendlyByteBuf buf) {
        return new MessageUpdatePodium(buf.readLong(), PacketBufferUtils.readItemStack((ByteBuf)buf));
    }

    public static void write(MessageUpdatePodium message, FriendlyByteBuf buf) {
        buf.writeLong(message.blockPos);
        PacketBufferUtils.writeItemStack((ByteBuf)buf, (ItemStack)message.heldStack);
    }

    public static class Handler {
        public static void handle(MessageUpdatePodium message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    player = IceAndFire.PROXY.getClientSidePlayer();
                }
                if (player != null) {
                    BlockPos pos = BlockPos.m_122022_((long)message.blockPos);
                    BlockEntity patt1944$temp = player.m_9236_().m_7702_(pos);
                    if (patt1944$temp instanceof TileEntityPodium) {
                        TileEntityPodium podium = (TileEntityPodium)patt1944$temp;
                        podium.m_6836_(0, message.heldStack);
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

