/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockJar
extends BaseEntityBlock {
    protected static final VoxelShape AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public Item itemBlock;
    private final boolean empty;
    private final int pixieType;

    public BlockJar(int pixieType) {
        super(pixieType != -1 ? BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_280658_(NoteBlockInstrument.HAT).m_60955_().m_60988_().m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56744_).m_60953_(state -> pixieType == -1 ? 0 : 10).m_60916_((Block)IafBlockRegistry.JAR_EMPTY.get()) : BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_280658_(NoteBlockInstrument.HAT).m_60955_().m_60988_().m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56744_));
        this.empty = pixieType == -1;
        this.pixieType = pixieType;
    }

    static String name(int pixieType) {
        if (pixieType == -1) {
            return "pixie_jar_empty";
        }
        return "pixie_jar_%d".formatted(pixieType);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AABB;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AABB;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        this.dropPixie(worldIn, pos);
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void dropPixie(Level world, BlockPos pos) {
        if (world.m_7702_(pos) != null && world.m_7702_(pos) instanceof TileEntityJar && ((TileEntityJar)world.m_7702_((BlockPos)pos)).hasPixie) {
            ((TileEntityJar)world.m_7702_(pos)).releasePixie();
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult resultIn) {
        if (!this.empty && world.m_7702_(pos) != null && world.m_7702_(pos) instanceof TileEntityJar && ((TileEntityJar)world.m_7702_((BlockPos)pos)).hasPixie && ((TileEntityJar)world.m_7702_((BlockPos)pos)).hasProduced) {
            ((TileEntityJar)world.m_7702_((BlockPos)pos)).hasProduced = false;
            ItemEntity item = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)IafItemRegistry.PIXIE_DUST.get()));
            if (!world.f_46443_) {
                world.m_7967_((Entity)item);
            }
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, IafSoundRegistry.PIXIE_HURT, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level world, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        if (world.m_7702_(pos) instanceof TileEntityJar) {
            TileEntityJar jar = (TileEntityJar)world.m_7702_(pos);
            if (!this.empty) {
                jar.hasPixie = true;
                jar.pixieType = this.pixieType;
            } else {
                jar.hasPixie = false;
            }
            jar.m_6596_();
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        return BlockJar.m_152132_(entityType, (BlockEntityType)((BlockEntityType)IafTileEntityRegistry.PIXIE_JAR.get()), TileEntityJar::tick);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileEntityJar(pos, state, this.empty);
    }
}

