/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.services;

import dev.dediamondpro.resourcify.config.Config;
import dev.dediamondpro.resourcify.services.IService;
import dev.dediamondpro.resourcify.services.ProjectType;
import dev.dediamondpro.resourcify.services.curseforge.CurseForgeService;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Ldev/dediamondpro/resourcify/services/ServiceRegistry;", "", "<init>", "()V", "", "Ldev/dediamondpro/resourcify/services/IService;", "getAllServices", "()Ljava/util/List;", "Ldev/dediamondpro/resourcify/services/ProjectType;", "projectType", "getServices", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/List;", "", "name", "getService", "(Ljava/lang/String;Ldev/dediamondpro/resourcify/services/ProjectType;)Ldev/dediamondpro/resourcify/services/IService;", "getDefaultService", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ldev/dediamondpro/resourcify/services/IService;", "service", "", "registerService", "(Ldev/dediamondpro/resourcify/services/IService;)V", "", "services", "Ljava/util/List;", "Resourcify (1.20.1-forge)-1.7.4"})
@SourceDebugExtension(value={"SMAP\nServiceRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceRegistry.kt\ndev/dediamondpro/resourcify/services/ServiceRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n774#2:52\n865#2,2:53\n295#2,2:55\n*S KotlinDebug\n*F\n+ 1 ServiceRegistry.kt\ndev/dediamondpro/resourcify/services/ServiceRegistry\n*L\n37#1:52\n37#1:53,2\n41#1:55,2\n*E\n"})
public final class ServiceRegistry {
    @NotNull
    public static final ServiceRegistry INSTANCE = new ServiceRegistry();
    @NotNull
    private static final List<IService> services = new ArrayList();

    private ServiceRegistry() {
    }

    @NotNull
    public final List<IService> getAllServices() {
        return services;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IService> getServices(@NotNull ProjectType projectType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)projectType), (String)"projectType");
        Iterable $this$filter$iv = services;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IService it = (IService)element$iv$iv;
            boolean bl = false;
            if (!it.isProjectTypeSupported(projectType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final IService getService(@NotNull String name, @NotNull ProjectType projectType) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)projectType), (String)"projectType");
            Iterable $this$firstOrNull$iv = this.getServices(projectType);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IService it = (IService)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final IService getDefaultService(@NotNull ProjectType projectType) {
        Intrinsics.checkNotNullParameter((Object)((Object)projectType), (String)"projectType");
        IService iService = this.getService(Config.Companion.getInstance().getDefaultService(), projectType);
        if (iService == null) {
            iService = (IService)CollectionsKt.first(this.getServices(projectType));
        }
        return iService;
    }

    public final void registerService(@NotNull IService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        services.add(service);
    }

    static {
        INSTANCE.registerService(ModrinthService.INSTANCE);
        INSTANCE.registerService(CurseForgeService.INSTANCE);
    }
}

