/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.gui.world;

import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.gui.PaginatedScreen;
import dev.dediamondpro.resourcify.libs.universal.UScreen;
import dev.dediamondpro.resourcify.util.DownloadManager;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 12\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0017\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b(\u0010)R\u0018\u0010+\u001a\u0004\u0018\u00010*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Ldev/dediamondpro/resourcify/gui/world/WorldDownloadingScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "parent", "Ljava/io/File;", "world", "Ljava/net/URI;", "uri", "<init>", "(Ldev/dediamondpro/resourcify/gui/PaginatedScreen;Ljava/io/File;Ljava/net/URI;)V", "", "init", "()V", "repositionElements", "tick", "Lnet/minecraft/network/chat/Component;", "newText", "updateText", "(Lnet/minecraft/network/chat/Component;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "mouseX", "mouseY", "", "partialTick", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "getTextWidth", "()I", "", "shouldCloseOnEsc", "()Z", "Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "getParent", "()Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "Ljava/io/File;", "getWorld", "()Ljava/io/File;", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "Lnet/minecraft/client/gui/components/Button;", "cancelButton", "Lnet/minecraft/client/gui/components/Button;", "textWidget", "Lnet/minecraft/network/chat/Component;", "triggeredLoad", "Z", "Companion", "Resourcify (1.20.1-forge)-1.7.4"})
public final class WorldDownloadingScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaginatedScreen parent;
    @NotNull
    private final File world;
    @NotNull
    private final URI uri;
    @Nullable
    private Button cancelButton;
    @NotNull
    private Component textWidget;
    private boolean triggeredLoad;

    public WorldDownloadingScreen(@NotNull PaginatedScreen parent, @NotNull File world, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object[] objectArray = new Object[]{0};
        super((Component)Component.m_237110_((String)"resourcify.world.downloading", (Object[])objectArray));
        this.parent = parent;
        this.world = world;
        this.uri = uri;
        Object[] objectArray2 = new Object[]{0};
        MutableComponent mutableComponent = Component.m_237110_((String)"resourcify.world.downloading", (Object[])objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        this.textWidget = (Component)mutableComponent;
    }

    @NotNull
    public final PaginatedScreen getParent() {
        return this.parent;
    }

    @NotNull
    public final File getWorld() {
        return this.world;
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    protected void m_7856_() {
        super.m_7856_();
        int width = this.getTextWidth();
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)((Component)Component.m_237115_((String)"resourcify.world.cancel")), arg_0 -> WorldDownloadingScreen.init$lambda$0(this, arg_0)).m_252780_(width + 24).m_252794_(this.f_96543_ / 2 - width / 2 - 12, this.f_96544_ / 2 + 20).m_253136_());
    }

    protected void m_267719_() {
        block2: {
            super.m_267719_();
            int width = this.getTextWidth();
            Button button = this.cancelButton;
            if (button != null) {
                button.m_93674_(width + 24);
            }
            Button button2 = this.cancelButton;
            if (button2 != null) {
                button2.m_252865_(this.f_96543_ / 2 - width / 2 - 12);
            }
            Button button3 = this.cancelButton;
            if (button3 == null) break block2;
            button3.m_253211_(this.f_96544_ / 2 + 20);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        Float progress = DownloadManager.INSTANCE.getProgress(this.uri);
        if (progress != null) {
            Object[] objectArray = new Object[]{(int)Math.rint((double)progress.floatValue() * 100.0)};
            MutableComponent mutableComponent = Component.m_237110_((String)"resourcify.world.downloading", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.updateText((Component)mutableComponent);
            this.m_267719_();
            return;
        }
        if (this.triggeredLoad) {
            return;
        }
        this.triggeredLoad = true;
        String string = this.world.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Companion.openWorld(string);
    }

    private final void updateText(Component newText) {
        this.textWidget = newText;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        this.m_280039_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.textWidget, this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private final int getTextWidth() {
        return this.f_96547_.m_92852_((FormattedText)this.textWidget);
    }

    public boolean m_6913_() {
        return false;
    }

    private static final void init$lambda$0(WorldDownloadingScreen this$0, Button it) {
        DownloadManager.INSTANCE.cancelDownload(this$0.uri);
        UScreen.Companion.displayScreen(this$0.parent);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/dediamondpro/resourcify/gui/world/WorldDownloadingScreen$Companion;", "", "<init>", "()V", "", "name", "", "openWorld", "(Ljava/lang/String;)V", "Lnet/minecraft/client/gui/screens/Screen;", "createFailScreen", "(Ljava/lang/String;)Lnet/minecraft/client/gui/screens/Screen;", "Resourcify (1.20.1-forge)-1.7.4"})
    public static final class Companion {
        private Companion() {
        }

        public final void openWorld(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Minecraft minecraft = Minecraft.m_91087_();
            if (!minecraft.m_91392_().m_78255_(name)) {
                Constants.INSTANCE.getLOGGER().error("Failed to open world " + name + ", it doesn't exist");
                UScreen.Companion.displayScreen(this.createFailScreen(name));
            } else {
                MultiThreadingKt.runAsync(() -> Companion.openWorld$lambda$1(minecraft, name));
            }
        }

        private final Screen createFailScreen(String name) {
            Object[] objectArray = new Object[]{name};
            return (Screen)new DisconnectedScreen((Screen)new SelectWorldScreen((Screen)new TitleScreen()), (Component)Component.m_237115_((String)"resourcify.world.failed"), (Component)Component.m_237110_((String)"resourcify.world.failed.description", (Object[])objectArray), (Component)Component.m_237115_((String)"gui.toWorld"));
        }

        private static final void openWorld$lambda$1$lambda$0(Minecraft $minecraft, String $name) {
            Minecraft minecraft = $minecraft;
            Intrinsics.checkNotNull((Object)minecraft);
            minecraft.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
            $minecraft.m_231466_().m_233133_(Companion.createFailScreen($name), $name);
        }

        private static final void openWorld$lambda$1(Minecraft $minecraft, String $name) {
            $minecraft.execute(() -> Companion.openWorld$lambda$1$lambda$0($minecraft, $name));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

