/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ReplaceNotAirProcessor
extends StructureProcessor {
    public static final Codec<ReplaceNotAirProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().listOf().xmap(Sets::newHashSet, Lists::newArrayList).optionalFieldOf("blocks_to_always_replace", new HashSet()).forGetter(config -> config.blocksToAlwaysReplace)).apply((Applicative)instance, instance.stable(ReplaceNotAirProcessor::new)));
    public final HashSet<Block> blocksToAlwaysReplace;

    private ReplaceNotAirProcessor(HashSet<Block> blocksToAlwaysReplace) {
        this.blocksToAlwaysReplace = blocksToAlwaysReplace;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        BlockPos position;
        BlockState worldState;
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.f_74675_())) {
            return structureBlockInfoWorld;
        }
        if ((this.blocksToAlwaysReplace.isEmpty() || this.blocksToAlwaysReplace.contains(structureBlockInfoWorld.f_74676_().m_60734_())) && (worldState = levelReader.m_8055_(position = structureBlockInfoWorld.f_74675_())).m_60795_()) {
            return null;
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.REPLACE_NOT_AIR_PROCESSOR.get();
    }
}

