/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.FloralFillWithRootminConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;

public class FloralFillWithRootmin
extends Feature<FloralFillWithRootminConfig> {
    public FloralFillWithRootmin(Codec<FloralFillWithRootminConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<FloralFillWithRootminConfig> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource randomSource = context.m_225041_();
        FloralFillWithRootminConfig config = (FloralFillWithRootminConfig)context.m_159778_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos chunkCornerPos = new ChunkPos(context.m_159777_()).m_45615_().m_6630_(context.m_159777_().m_123342_());
        Optional optionalBlocks = BuiltInRegistries.f_256975_.m_203431_(config.flowerTag);
        List blockList = GeneralUtils.convertHoldersetToList(optionalBlocks);
        blockList.removeIf(block -> block.m_49966_().m_204336_(((FloralFillWithRootminConfig)context.m_159778_()).disallowedFlowerTag));
        if (blockList.isEmpty()) {
            return false;
        }
        ChunkAccess cachedChunk = level.m_46865_(chunkCornerPos);
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.m_159774_());
        for (int xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                boolean spawnRootmin = false;
                boolean spawnFlower = false;
                if (randomSource.m_188501_() < config.rootminChance) {
                    spawnRootmin = true;
                } else if (randomSource.m_188501_() < config.flowerChance) {
                    spawnFlower = true;
                }
                if (!spawnRootmin && !spawnFlower) continue;
                mutable.m_122190_((Vec3i)chunkCornerPos).m_122184_(xOffset, 0, zOffset);
                boolean isAtGrassBlock = this.setMutableToGrassBlock(cachedChunk, bulkSectionAccess, mutable);
                if (!isAtGrassBlock || mutable.m_123342_() <= cachedChunk.m_141937_() || mutable.m_123342_() >= cachedChunk.m_151558_() || !bulkSectionAccess.getBlockState(mutable.m_7494_()).m_60795_()) continue;
                BlockState chosenFlower = ((Block)blockList.get(randomSource.m_188503_(blockList.size()))).m_49966_();
                if (chosenFlower.m_61138_((Property)BlockStateProperties.f_271526_)) {
                    chosenFlower = (BlockState)chosenFlower.m_61124_((Property)BlockStateProperties.f_271526_, (Comparable)Integer.valueOf(4));
                }
                if (chosenFlower.m_60734_() instanceof DoublePlantBlock) {
                    chosenFlower = (BlockState)chosenFlower.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                }
                if (spawnRootmin && mutable.m_123342_() != 39) {
                    bulkSectionAccess.setBlockState((BlockPos)mutable, Blocks.f_50016_.m_49966_(), false);
                    Entity spawningEntity = BzEntities.ROOTMIN.get().m_20615_((Level)level.m_6018_());
                    if (!(spawningEntity instanceof RootminEntity)) continue;
                    RootminEntity rootmin = (RootminEntity)spawningEntity;
                    Optional optionalRootminBlocks = BuiltInRegistries.f_256975_.m_203431_(config.rootminFlowerTag);
                    List rootminBlockList = GeneralUtils.convertHoldersetToList(optionalRootminBlocks);
                    rootminBlockList.removeIf(block -> block.m_49966_().m_204336_(((FloralFillWithRootminConfig)context.m_159778_()).disallowedRootminFlowerTag));
                    BlockState chosenRootminFlower = rootminBlockList.isEmpty() ? Blocks.f_50016_.m_49966_() : ((Block)rootminBlockList.get(randomSource.m_188503_(rootminBlockList.size()))).m_49966_();
                    rootmin.m_21530_();
                    rootmin.setFlowerBlock(chosenRootminFlower);
                    rootmin.m_7678_((double)mutable.m_123341_() + 0.5, mutable.m_123342_(), (double)mutable.m_123343_() + 0.5, 0.0f, 0.0f);
                    rootmin.hideAsBlock(new Vec3((double)mutable.m_123341_() + 0.5, (double)mutable.m_123342_(), (double)mutable.m_123343_() + 0.5));
                    rootmin.f_20885_ = 0.0f;
                    rootmin.f_20886_ = 0.0f;
                    rootmin.f_20883_ = 0.0f;
                    rootmin.f_20884_ = 0.0f;
                    rootmin.m_6518_((ServerLevelAccessor)level, level.m_6436_((BlockPos)mutable), MobSpawnType.CHUNK_GENERATION, null, null);
                    level.m_47205_((Entity)rootmin);
                    mutable.m_122173_(Direction.UP);
                    BlockState aboveState = bulkSectionAccess.getBlockState((BlockPos)mutable);
                    if (!aboveState.m_204336_(BlockTags.f_278394_)) continue;
                    bulkSectionAccess.setBlockState((BlockPos)mutable, Blocks.f_50016_.m_49966_(), false);
                    if (!(aboveState.m_60734_() instanceof DoublePlantBlock)) continue;
                    mutable.m_122173_(Direction.UP);
                    bulkSectionAccess.setBlockState((BlockPos)mutable, Blocks.f_50016_.m_49966_(), false);
                    continue;
                }
                if (chosenFlower.m_60734_() instanceof DoublePlantBlock) {
                    mutable.m_122175_(Direction.UP, 2);
                    BlockState aboveState = bulkSectionAccess.getBlockState((BlockPos)mutable);
                    if (!aboveState.m_60795_() && !aboveState.m_204336_(BlockTags.f_278394_)) continue;
                    mutable.m_122173_(Direction.DOWN);
                    bulkSectionAccess.setBlockState((BlockPos)mutable, chosenFlower, false);
                    chosenFlower = (BlockState)chosenFlower.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                    mutable.m_122173_(Direction.UP);
                    bulkSectionAccess.setBlockState((BlockPos)mutable, chosenFlower, false);
                    continue;
                }
                mutable.m_122173_(Direction.UP);
                bulkSectionAccess.setBlockState((BlockPos)mutable, chosenFlower, false);
            }
        }
        return true;
    }

    private boolean setMutableToGrassBlock(ChunkAccess cachedChunk, UnsafeBulkSectionAccess bulkSectionAccess, BlockPos.MutableBlockPos mutable) {
        BlockState currentState = bulkSectionAccess.getBlockState((BlockPos)mutable);
        Direction previousDirection = null;
        while (!currentState.m_60713_(Blocks.f_50440_) && mutable.m_123342_() > cachedChunk.m_141937_() && mutable.m_123342_() < cachedChunk.m_151558_()) {
            if (currentState.m_60713_(Blocks.f_50627_)) {
                if (previousDirection == Direction.DOWN) {
                    return false;
                }
                mutable.m_122173_(Direction.UP);
                previousDirection = Direction.UP;
            } else if (currentState.m_60795_() || !currentState.m_60819_().m_76178_()) {
                if (previousDirection == Direction.UP) {
                    return false;
                }
                mutable.m_122173_(Direction.DOWN);
                previousDirection = Direction.DOWN;
            } else {
                if (previousDirection == Direction.DOWN) {
                    return false;
                }
                mutable.m_122173_(Direction.UP);
                previousDirection = Direction.UP;
            }
            currentState = bulkSectionAccess.getBlockState((BlockPos)mutable);
        }
        return currentState.m_60713_(Blocks.f_50440_);
    }
}

