/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.ServerGoingToStopEvent;
import com.telepathicgrunt.the_bumblezone.utils.forge.ThreadExecutorImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;

public class ThreadExecutor {
    private static ExecutorService LOCATING_EXECUTOR_SERVICE = null;
    private static final AtomicInteger runningSearches = new AtomicInteger(0);
    private static final AtomicInteger queuedSearches = new AtomicInteger(0);
    private static final LinkedHashMap<UUID, Optional<BlockPos>> SEARCH_RESULTS = new LinkedHashMap<UUID, Optional<BlockPos>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, Optional<BlockPos>> eldest) {
            return this.size() >= 50;
        }
    };

    public static void setupExecutorService() {
        ThreadExecutor.shutdownExecutorService();
        LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(3, new ThreadFactory(){
            private static final AtomicInteger poolNum = new AtomicInteger(1);
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "bumblezone_locator_and_teleportation-" + poolNum.getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(Runnable r) {
                return ThreadExecutor.createServerThread(r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Thread createServerThread(Runnable runnable, String name) {
        void var1_1;
        return ThreadExecutorImpl.createServerThread(runnable, (String)var1_1);
    }

    private static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    public static void handleServerStoppingEvent(ServerGoingToStopEvent ignoredEvent) {
        ThreadExecutor.shutdownExecutorService();
    }

    public static boolean isRunningASearch() {
        return runningSearches.get() > 0;
    }

    public static boolean hasQueuedSearch() {
        return queuedSearches.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<BlockPos> getSearchResult(UUID searchId) {
        LinkedHashMap<UUID, Optional<BlockPos>> linkedHashMap = SEARCH_RESULTS;
        synchronized (linkedHashMap) {
            if (!SEARCH_RESULTS.containsKey(searchId)) {
                return null;
            }
            return SEARCH_RESULTS.get(searchId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchResult(UUID searchId) {
        LinkedHashMap<UUID, Optional<BlockPos>> linkedHashMap = SEARCH_RESULTS;
        synchronized (linkedHashMap) {
            SEARCH_RESULTS.remove(searchId);
        }
    }

    public static LocateTask<BlockPos> locate(ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        queuedSearches.getAndIncrement();
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                runningSearches.getAndIncrement();
                queuedSearches.getAndDecrement();
                ThreadExecutor.doLocateLevel(completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread structure locating crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<BlockPos>(level.m_7654_(), completableFuture, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocateTask<BlockPos> locate(ServerLevel level, UUID searchId, ResourceKey<Structure> structureKey, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        queuedSearches.getAndIncrement();
        LinkedHashMap<UUID, Optional<BlockPos>> linkedHashMap = SEARCH_RESULTS;
        synchronized (linkedHashMap) {
            SEARCH_RESULTS.put(searchId, Optional.empty());
        }
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                runningSearches.getAndIncrement();
                queuedSearches.getAndDecrement();
                ThreadExecutor.doLocateLevel(completableFuture, level, searchId, structureKey, pos, searchRadius, skipKnownStructures);
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread structure locating crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<BlockPos>(level.m_7654_(), completableFuture, future);
    }

    public static LocateTask<Optional<Vec3>> dimensionDestinationSearch(MinecraftServer minecraftServer, Supplier<Optional<Vec3>> searchFunction) {
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> {
            try {
                completableFuture.complete((Optional)searchFunction.get());
            }
            catch (Exception e) {
                Bumblezone.LOGGER.error("Off thread teleport destination search crashed. Exception is: ", (Throwable)e);
            }
        });
        return new LocateTask<Optional<Vec3>>(minecraftServer, completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<BlockPos> completableFuture, ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        BlockPos foundPos = level.m_215011_(structureTag, pos, searchRadius, skipExistingChunks);
        completableFuture.complete(foundPos);
        runningSearches.getAndDecrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLocateLevel(CompletableFuture<BlockPos> completableFuture, ServerLevel level, UUID searchId, ResourceKey<Structure> structureKey, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        Registry structureRegistry = (Registry)level.m_9598_().m_6632_(Registries.f_256944_).get();
        Optional structureRegistryHolder = structureRegistry.m_203636_(structureKey);
        if (structureRegistryHolder.isEmpty()) {
            completableFuture.complete(null);
            runningSearches.getAndDecrement();
            LinkedHashMap<UUID, Optional<BlockPos>> linkedHashMap = SEARCH_RESULTS;
            synchronized (linkedHashMap) {
                SEARCH_RESULTS.remove(searchId);
            }
            return;
        }
        Pair foundPos = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureRegistryHolder.get()}), pos, searchRadius, skipExistingChunks);
        completableFuture.complete(foundPos != null ? (BlockPos)foundPos.getFirst() : null);
        runningSearches.getAndDecrement();
        LinkedHashMap<UUID, Optional<BlockPos>> linkedHashMap = SEARCH_RESULTS;
        synchronized (linkedHashMap) {
            if (foundPos == null) {
                SEARCH_RESULTS.remove(searchId);
            } else {
                SEARCH_RESULTS.put(searchId, Optional.of((BlockPos)foundPos.getFirst()));
            }
        }
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.m_18707_(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

