/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.mojang.datafixers.util.Function6;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.ProjectileHitEvent;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.BroodBlockModdedCompatDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PotionOfBeesCompat
implements ModCompat {
    private static Optional<EntityType<?>> SPLASH_POTION_OF_BEES_ENTITY;
    private static Optional<EntityType<?>> LINGERING_POTION_OF_BEES_ENTITY;
    private static Optional<Item> POTION_OF_BEES;
    private static Optional<Item> SPLASH_POTION_OF_BEES;
    private static Optional<Item> LINGERING_POTION_OF_BEES;

    public PotionOfBeesCompat() {
        POTION_OF_BEES = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("potionofbees", "potion_of_bees"));
        SPLASH_POTION_OF_BEES = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("potionofbees", "splash_potion_of_bees"));
        LINGERING_POTION_OF_BEES = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("potionofbees", "lingering_potion_of_bees"));
        SPLASH_POTION_OF_BEES_ENTITY = BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation("potionofbees", "splash_potion_of_bees"));
        LINGERING_POTION_OF_BEES_ENTITY = BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation("potionofbees", "lingering_potion_of_bees"));
        if (POTION_OF_BEES.isPresent() && BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            PotionOfBeesCompat.setupDispenserCompat(POTION_OF_BEES.get());
        }
        if (SPLASH_POTION_OF_BEES.isPresent() && BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            PotionOfBeesCompat.setupDispenserCompat(SPLASH_POTION_OF_BEES.get());
        }
        if (LINGERING_POTION_OF_BEES.isPresent() && BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            PotionOfBeesCompat.setupDispenserCompat(LINGERING_POTION_OF_BEES.get());
        }
        ProjectileHitEvent.EVENT.addListener(PotionOfBeesCompat::onProjectileHit);
        ModChecker.potionOfBeesPresent = true;
    }

    private static void setupDispenserCompat(Item containerItem) {
        BroodBlockModdedCompatDispenseBehavior newDispenseBehavior = new BroodBlockModdedCompatDispenseBehavior(((DispenserBlockInvoker)Blocks.f_50061_).bumblezone$invokeGetDispenseMethod(new ItemStack((ItemLike)containerItem)), (Function6<DispenseItemBehavior, BlockSource, ItemStack, ServerLevel, BlockPos, BlockState, ItemStack>)((Function6)(originalModdedDispenseBehavior, blockSource, itemStack, serverLevel, blockPos, blockState) -> {
            if (PotionOfBeesCompat.isLingeringPotionOfBeesItem(itemStack)) {
                PotionOfBeesCompat.reviveBroodsInRange((Level)serverLevel, blockPos, 3);
            } else if (PotionOfBeesCompat.isSplashPotionOfBeesItem(itemStack)) {
                PotionOfBeesCompat.reviveBroodsInRange((Level)serverLevel, blockPos, 1);
            } else {
                serverLevel.m_46597_(blockPos, (BlockState)((BlockState)BzBlocks.HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)HoneycombBrood.f_52588_, (Comparable)((Direction)blockState.m_61143_((Property)EmptyHoneycombBrood.f_52588_)))).m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(3)));
            }
            itemStack.m_41774_(1);
            if (!BzGeneralConfigs.dispensersDropGlassBottles) {
                if (!itemStack.m_41619_()) {
                    ItemStack honeyBottle;
                    DispenserBlockEntity dispenser;
                    if (blockSource.m_8118_() instanceof DispenserBlockEntity && !HopperBlockEntity.m_59326_(null, (Container)(dispenser = (DispenserBlockEntity)blockSource.m_8118_()), (ItemStack)(honeyBottle = new ItemStack((ItemLike)Items.f_42590_)), null).m_41619_()) {
                        BroodBlockModdedCompatDispenseBehavior.DEFAULT_DROP_ITEM_BEHAVIOR.m_6115_(blockSource, honeyBottle);
                    }
                } else {
                    itemStack = new ItemStack((ItemLike)Items.f_42590_);
                }
            } else {
                BroodBlockModdedCompatDispenseBehavior.DEFAULT_DROP_ITEM_BEHAVIOR.m_6115_(blockSource, new ItemStack((ItemLike)Items.f_42590_));
            }
            return itemStack;
        }));
        DispenserBlock.m_52672_((ItemLike)containerItem, (DispenseItemBehavior)newDispenseBehavior);
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.EMPTY_BROOD);
    }

    public static boolean isPotionOfBeesItem(ItemStack itemStack) {
        return POTION_OF_BEES.isPresent() && itemStack.m_150930_(POTION_OF_BEES.get());
    }

    public static boolean isSplashPotionOfBeesItem(ItemStack itemStack) {
        return SPLASH_POTION_OF_BEES.isPresent() && itemStack.m_150930_(SPLASH_POTION_OF_BEES.get());
    }

    public static boolean isLingeringPotionOfBeesItem(ItemStack itemStack) {
        return LINGERING_POTION_OF_BEES.isPresent() && itemStack.m_150930_(LINGERING_POTION_OF_BEES.get());
    }

    private static void onProjectileHit(boolean cancelled, ProjectileHitEvent event) {
        if (BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock && event.projectile() != null) {
            if (SPLASH_POTION_OF_BEES_ENTITY.isPresent() && event.projectile().m_6095_() == SPLASH_POTION_OF_BEES_ENTITY.get()) {
                PotionOfBeesCompat.reviveLarvaBlockEvent(event.projectile(), event.hitResult(), 1);
            } else if (LINGERING_POTION_OF_BEES_ENTITY.isPresent() && event.projectile().m_6095_() == LINGERING_POTION_OF_BEES_ENTITY.get()) {
                PotionOfBeesCompat.reviveLarvaBlockEvent(event.projectile(), event.hitResult(), 3);
            }
        }
    }

    private static void reviveLarvaBlockEvent(Projectile projectile, HitResult rayTraceResult, int range) {
        Level world = projectile.m_9236_();
        Vec3 hitBlockPos = rayTraceResult.m_82450_();
        BlockPos originalPosition = BlockPos.m_274446_((Position)hitBlockPos);
        PotionOfBeesCompat.reviveBroodsInRange(world, originalPosition, range);
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (PotionOfBeesCompat.isPotionOfBeesItem(itemstack) && !playerEntity.m_6047_()) {
            if (!playerEntity.m_7500_()) {
                playerEntity.m_21008_(playerHand, new ItemStack((ItemLike)Items.f_42590_));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void reviveBroodsInRange(Level world, BlockPos originalPosition, int range) {
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos().m_122190_((Vec3i)originalPosition);
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    position.m_122190_((Vec3i)originalPosition).m_122184_(x, y, z);
                    BlockState block = world.m_8055_((BlockPos)position);
                    if (!block.m_60734_().equals(BzBlocks.EMPTY_HONEYCOMB_BROOD.get())) continue;
                    PotionOfBeesCompat.reviveLarvaBlock(world, block, (BlockPos)position);
                }
            }
        }
    }

    private static void reviveLarvaBlock(Level world, BlockState state, BlockPos position) {
        world.m_46597_(position, (BlockState)((BlockState)BzBlocks.HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)))).m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(3 - world.f_46441_.m_188503_(world.f_46441_.m_188503_(world.f_46441_.m_188503_(4) + 1) + 1))));
    }
}

