/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.forge;

import com.telepathicgrunt.the_bumblezone.blocks.blockentities.HoneyCocoonBlockEntity;
import com.telepathicgrunt.the_bumblezone.modcompat.LootrCompat;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.api.LootrAPI;

public class LootrCompatImpl {
    public static MenuProvider getCocoonMenu(ServerPlayer player, HoneyCocoonBlockEntity blockEntity) {
        return LootrAPI.getModdedMenu((Level)blockEntity.m_58904_(), (UUID)blockEntity.getBlockEntityUuid(), (BlockPos)blockEntity.m_58899_(), (ServerPlayer)player, (RandomizableContainerBlockEntity)blockEntity, (lootPlayer, inventory, table, seed) -> LootrCompat.unpackLootTable(blockEntity, lootPlayer, inventory, table, seed), blockEntity::getLootTable, blockEntity::getLootSeed, LootrCompat::menuBuilder);
    }

    public static void unpackLootTable(HoneyCocoonBlockEntity blockEntity, Player player, Container inventory, ResourceLocation table, long seed) {
        if (table == null) {
            LootrAPI.LOG.error("Unable to fill loot cocoon in " + String.valueOf(blockEntity.m_58904_().m_46472_()) + " at " + String.valueOf(blockEntity.m_58899_()) + " as the loot table was null.");
            return;
        }
        LootTable loottable = blockEntity.m_58904_().m_7654_().m_278653_().m_278676_(table);
        if (loottable == LootTable.f_79105_) {
            LootrAPI.LOG.error("Unable to fill loot cocoon in " + String.valueOf(blockEntity.m_58904_().m_46472_()) + " at " + String.valueOf(blockEntity.m_58899_()) + " as the loot table '" + String.valueOf(table) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
            return;
        }
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)blockEntity.m_58904_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockEntity.m_58899_()));
        if (player != null) {
            builder.m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
        }
        loottable.m_287188_(inventory, builder.m_287235_(LootContextParamSets.f_81411_), LootrAPI.getLootSeed((long)seed));
    }
}

