/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RootminAvoidEntityGoal
extends Goal {
    protected final RootminEntity mob;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    @Nullable
    protected LivingEntity toAvoid;
    protected final float maxDist;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    protected final TagKey<EntityType<?>> avoidTag;
    protected final Predicate<LivingEntity> avoidPredicate;
    protected final Predicate<LivingEntity> predicateOnAvoidEntity;
    private final TargetingConditions avoidEntityTargeting;
    protected float fleeTime = 0.0f;

    public RootminAvoidEntityGoal(RootminEntity pathfinderMob, TagKey<EntityType<?>> typeTagKey, float range, double walkSpeedModifier, double runSpeedModifier) {
        this(pathfinderMob, typeTagKey, livingEntity -> true, range, walkSpeedModifier, runSpeedModifier, EntitySelector.f_20406_::test);
    }

    public RootminAvoidEntityGoal(RootminEntity pathfinderMob, TagKey<EntityType<?>> typeTagKey, Predicate<LivingEntity> predicate, float range, double walkSpeedModifier, double runSpeedModifier, Predicate<LivingEntity> predicate2) {
        this.mob = pathfinderMob;
        this.avoidTag = typeTagKey;
        this.avoidPredicate = predicate;
        this.maxDist = range;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = runSpeedModifier;
        this.predicateOnAvoidEntity = predicate2;
        this.pathNav = pathfinderMob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)range).m_26888_(predicate2.and(predicate));
    }

    public boolean m_8036_() {
        if (this.mob.animationTimeBetweenHiding > 0 || this.mob.isHidden) {
            return false;
        }
        if (this.mob.f_19797_ - this.mob.m_21213_() < 1200 && this.mob.attackerMemory != null) {
            distApart = this.mob.attackerMemory.m_20183_().m_123333_((Vec3i)this.mob.m_20183_());
            if ((float)distApart < this.maxDist) {
                this.toAvoid = this.mob.attackerMemory;
            }
        } else if (this.mob.f_19797_ - this.mob.m_21213_() < 1200 && this.mob.m_21188_() != null && !(this.mob.m_21188_() instanceof RootminEntity)) {
            distApart = this.mob.m_21188_().m_20183_().m_123333_((Vec3i)this.mob.m_20183_());
            if ((float)distApart < this.maxDist) {
                this.toAvoid = this.mob.m_21188_();
                this.mob.attackerMemory = this.mob.m_21188_();
            }
        } else {
            this.toAvoid = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(LivingEntity.class, this.mob.m_20191_().m_82377_((double)this.maxDist, 3.0, (double)this.maxDist), livingEntity -> livingEntity.m_6095_().m_204039_(this.avoidTag)), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        }
        if (this.toAvoid == null) {
            return false;
        }
        Vec3 vec3 = null;
        for (int i = 0; i < 10 && (vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)26, (int)8, (Vec3)this.toAvoid.m_20182_())) == null; ++i) {
        }
        if (vec3 == null) {
            return false;
        }
        if (this.toAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.toAvoid.m_20280_((Entity)this.mob)) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return this.path != null && this.path.m_77398_() > 1;
    }

    public boolean m_8045_() {
        if (this.pathNav.m_26571_() || this.toAvoid != null && this.toAvoid.m_21224_()) {
            return false;
        }
        if (this.mob.animationTimeBetweenHiding > 0 || this.mob.isHidden) {
            return false;
        }
        if (this.fleeTime > 200.0f) {
            return false;
        }
        this.mob.rootminToLookAt = null;
        return true;
    }

    public void m_8056_() {
        this.fleeTime = 0.0f;
        this.pathNav.m_26536_(this.path, this.mob.m_20280_((Entity)this.toAvoid) < 196.0 ? this.sprintSpeedModifier : this.walkSpeedModifier);
    }

    public void m_8041_() {
        this.fleeTime = 0.0f;
        this.pathNav.m_26573_();
        this.toAvoid = null;
    }

    public void m_8037_() {
        if (this.mob.m_20280_((Entity)this.toAvoid) < 196.0) {
            this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
            if (RootminEntity.POSES_THAT_CAN_BE_FEAR_INTERRUPTED.contains((Object)this.mob.getRootminPose())) {
                this.mob.setRootminPose(RootminPose.RUN);
            }
        } else {
            this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
            if (RootminEntity.POSES_THAT_CAN_BE_FEAR_INTERRUPTED.contains((Object)this.mob.getRootminPose())) {
                this.mob.setRootminPose(RootminPose.WALK);
            }
        }
        RootminEntity.considerHiddenRootminsInPath(this.path, this.mob);
        RootminEntity.jumpFix(this.path, this.mob);
        if (this.mob.f_20916_ > 0) {
            this.fleeTime = 0.0f;
        }
        this.fleeTime += 1.0f;
    }
}

