/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.events.BlockBreakEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityHurtEvent;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerPickupItemEvent;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.state.BlockState;

public class BeeAggression {
    private static final Set<String> LIST_OF_BEE_HATING_NAMES = Set.of("bear", "panda", "wasp", "spider");
    private static final Set<EntityType<?>> SET_OF_BEE_HATED_NAMED_ENTITIES = new HashSet();
    private static final Set<EntityType<?>> SET_OF_BEE_NAMED_ENTITIES = new HashSet();

    public static void setupBeeHatingList() {
        for (ResourceLocation id : BuiltInRegistries.f_256780_.m_6566_()) {
            String mobName = id.m_135815_();
            if (mobName.contains("bee") || mobName.contains("bumble_beast")) {
                SET_OF_BEE_NAMED_ENTITIES.add((EntityType)BuiltInRegistries.f_256780_.m_7745_(id));
            }
            if (!LIST_OF_BEE_HATING_NAMES.stream().anyMatch(mobName::contains)) continue;
            SET_OF_BEE_HATED_NAMED_ENTITIES.add((EntityType)BuiltInRegistries.f_256780_.m_7745_(id));
        }
    }

    public static void minedBlockAnger(boolean cancelled, BlockBreakEvent event) {
        if (cancelled) {
            return;
        }
        Player player = event.player();
        BlockState blockState = event.state();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (blockState.m_204336_(BzTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED)) {
                if (blockState.m_60713_(BzBlocks.HONEYCOMB_BROOD.get()) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)serverPlayer.m_21205_()) != 0) {
                    return;
                }
                BeeAggression.angerBees(serverPlayer, blockState.m_60713_(BzBlocks.HONEYCOMB_BROOD.get()));
            }
        }
    }

    public static void pickupItemAnger(PlayerPickupItemEvent event) {
        Player player = event.player();
        ItemStack itemStack = event.item();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (itemStack.m_204117_(BzTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP)) {
                BeeAggression.angerBees(serverPlayer, false);
            }
        }
    }

    private static void angerBees(ServerPlayer player, boolean removesProt) {
        if ((player.m_9236_().m_46472_().equals(BzDimension.BZ_WORLD_KEY) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && BzBeeAggressionConfigs.aggressiveBees && !player.m_7500_() && !player.m_5833_()) {
            if (!player.m_21023_(BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                if (!EssenceOfTheBees.hasEssence(player) && player.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                    MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.no_protection").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED);
                    player.m_5661_((Component)message, true);
                    player.m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
            } else {
                BzCriterias.HONEY_PERMISSION_TRIGGER.trigger(player);
                if (removesProt) {
                    player.m_21195_(BzEffects.PROTECTION_OF_THE_HIVE.get());
                }
            }
        }
    }

    public static void onLivingEntityHurt(EntityHurtEvent event) {
        LivingEntity livingEntity = event.entity();
        if (event.amount() > 0.0f && livingEntity != null && !livingEntity.m_9236_().m_5776_() && livingEntity instanceof Bee && event.source() != null && event.source().m_7639_() != null && livingEntity.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
            BeeAggression.beeHitAndAngered((Entity)livingEntity, event.source().m_7639_());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void beeHitAndAngered(Entity entity, Entity attackerEntity) {
        if (attackerEntity instanceof Player) {
            Player player = (Player)attackerEntity;
            if (!((Player)attackerEntity).m_7500_() && !attackerEntity.m_5833_()) {
                if (player.m_21023_(BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    player.m_21195_(BzEffects.PROTECTION_OF_THE_HIVE.get());
                    WrathOfTheHiveEffect.calmTheBees(player.m_9236_(), (LivingEntity)player);
                    return;
                }
                if (!entity.m_9236_().m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
                    if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) return;
                }
                if (!BzBeeAggressionConfigs.aggressiveBees) return;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BzCriterias.BEE_HIT_WRATH_OF_THE_HIVE_TRIGGER.trigger(serverPlayer, attackerEntity);
                }
                player.m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                return;
            }
        }
        if (!(attackerEntity instanceof Mob)) return;
        Mob mob = (Mob)attackerEntity;
        if (mob.m_21023_(BzEffects.PROTECTION_OF_THE_HIVE.get())) {
            mob.m_21195_(BzEffects.PROTECTION_OF_THE_HIVE.get());
            WrathOfTheHiveEffect.calmTheBees(mob.m_9236_(), (LivingEntity)mob);
            return;
        }
        if (!entity.m_9236_().m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
            if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) return;
        }
        if (!BzBeeAggressionConfigs.aggressiveBees) return;
        mob.m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, true));
    }

    public static void entityTypeBeeAnger(Entity entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((Mob)entity).m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 1, false, true));
        }
        if (entity != null && entity.m_9236_() != null && !entity.m_9236_().m_5776_() && entity.m_9236_().m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
            for (ModCompat compat : ModChecker.DIM_SPAWN_COMPATS) {
                compat.onEntitySpawnInDimension(entity);
            }
        }
    }

    public static boolean doesBeesHateEntity(Entity entity) {
        OwnableEntity ownableEntity;
        Mob mobEntity;
        if (entity != null && entity.m_9236_() != null && !entity.m_9236_().m_5776_() && entity.m_9236_().m_46472_().equals(BzDimension.BZ_WORLD_KEY) && BzBeeAggressionConfigs.aggressiveBees && entity instanceof Mob && !(mobEntity = (Mob)entity).m_21525_() && (!(entity instanceof OwnableEntity) || (ownableEntity = (OwnableEntity)entity).m_21805_() == null)) {
            if (mobEntity.m_6095_().m_204039_(BzTags.FORCED_BEE_CALM_AT)) {
                return false;
            }
            if (mobEntity.m_6095_().m_204039_(BzTags.FORCED_BEE_ANGRY_AT)) {
                return true;
            }
            return SET_OF_BEE_HATED_NAMED_ENTITIES.contains(entity.m_6095_()) || !SET_OF_BEE_NAMED_ENTITIES.contains(entity.m_6095_()) && mobEntity.m_6336_() == MobType.f_21642_;
        }
        return false;
    }

    public static boolean isBeelikeEntity(Entity entity) {
        return SET_OF_BEE_NAMED_ENTITIES.contains(entity.m_6095_());
    }

    public static boolean isBeelikeEntityType(EntityType<?> type) {
        return SET_OF_BEE_NAMED_ENTITIES.contains(type);
    }

    public static void playerTick(Player playerEntity) {
        if (!playerEntity.m_9236_().m_5776_() && playerEntity.m_21023_(BzEffects.WRATH_OF_THE_HIVE.get())) {
            if (playerEntity.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                playerEntity.m_21195_(BzEffects.WRATH_OF_THE_HIVE.get());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.m_9236_(), (LivingEntity)playerEntity);
            } else if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone && !playerEntity.m_9236_().m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
                playerEntity.m_21195_(BzEffects.WRATH_OF_THE_HIVE.get());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.m_9236_(), (LivingEntity)playerEntity);
            }
        }
        if (playerEntity.m_9236_().m_5776_()) {
            boolean wrathEffect = playerEntity.m_21023_(BzEffects.WRATH_OF_THE_HIVE.get());
            if (wrathEffect) {
                MusicHandler.playStopAngryBeeMusic(playerEntity, BzClientConfigs.playWrathOfHiveEffectMusic);
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.playStopAngryBeeMusic(playerEntity, false);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.m_9236_(), (LivingEntity)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }

    public static void applyAngerIfInTaggedStructures(ServerPlayer serverPlayer) {
        StructureManager structureManager = ((ServerLevel)serverPlayer.m_9236_()).m_215010_();
        if (structureManager.m_220491_(serverPlayer.m_20183_(), BzTags.WRATH_CAUSING).m_73603_()) {
            if (!FlowerHeadwearHelmet.getFlowerHeadwear((Entity)serverPlayer).m_41619_()) {
                BzCriterias.FLOWER_HEADWEAR_WRATH_STRUCTURE_TRIGGER.trigger(serverPlayer);
                return;
            }
            if (serverPlayer.m_7500_() || serverPlayer.m_5833_() || EssenceOfTheBees.hasEssence(serverPlayer)) {
                return;
            }
            if (!BzBeeAggressionConfigs.aggressiveBees || serverPlayer.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                return;
            }
            if (!serverPlayer.m_21023_(BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                if (!serverPlayer.m_21023_(BzEffects.WRATH_OF_THE_HIVE.get())) {
                    MutableComponent message = Component.m_237115_((String)"system.the_bumblezone.no_protection").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED);
                    serverPlayer.m_5661_((Component)message, true);
                }
                serverPlayer.m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
            }
        }
    }

    public static void preventAngerOnEssencedPlayers(List<Bee> beeList, List<Player> playerList) {
        for (int i = playerList.size() - 1; i >= 0; --i) {
            ServerPlayer serverPlayer;
            Player player = playerList.get(i);
            if (!(player instanceof ServerPlayer) || !EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)player)) continue;
            for (Bee bee : beeList) {
                if (bee.m_5448_() != player) continue;
                bee.m_6710_(null);
            }
            playerList.remove(i);
        }
    }

    public static void preventAngerOnEssencedPlayers(Player player, List<Entity> entityList) {
        ServerPlayer serverPlayer;
        if (player != null && player.m_9236_().m_5776_() || player instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)player)) {
            entityList.clear();
        }
    }
}

