/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ThrownStingerSpearEntity;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.mixin.entities.MobAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ThrownTridentAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.LivingEntityDataModule;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.platform.BzEnchantment;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class NeurotoxinsEnchantment
extends BzEnchantment {
    public NeurotoxinsEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.TRIDENT, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6183_(int level) {
        if (level > BzGeneralConfigs.neurotoxinMaxLevel) {
            return 201;
        }
        return 14 * level;
    }

    public int m_6175_(int level) {
        if (level > BzGeneralConfigs.neurotoxinMaxLevel) {
            return 200;
        }
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return BzGeneralConfigs.neurotoxinMaxLevel;
    }

    public static void entityHurtEvent(EntityAttackedEvent event) {
        if (event.entity().m_9236_().m_5776_()) {
            return;
        }
        ItemStack attackingItem = null;
        LivingEntity attacker = null;
        Entity entity = event.source().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            attacker = livingEntity = (LivingEntity)entity;
            attackingItem = attacker.m_21205_();
        }
        if (event.source().m_269533_(DamageTypeTags.f_268524_)) {
            Entity projectile = event.source().m_7640_();
            if (projectile instanceof ThrownTrident) {
                ThrownTrident thrownTrident = (ThrownTrident)projectile;
                attackingItem = ((ThrownTridentAccessor)thrownTrident).bumblezone$getTridentItem();
            } else if (projectile instanceof ThrownStingerSpearEntity) {
                ThrownStingerSpearEntity thrownStingerSpearEntity = (ThrownStingerSpearEntity)projectile;
                attackingItem = thrownStingerSpearEntity.getSpearItemStack();
            }
        }
        if (attackingItem != null && !attackingItem.m_41619_()) {
            NeurotoxinsEnchantment.applyNeurotoxins((Entity)attacker, (Entity)event.entity(), attackingItem);
        }
    }

    public static void applyNeurotoxins(Entity attacker, Entity victim, ItemStack itemStack) {
        LivingEntity livingEntity;
        int level = EnchantmentHelper.m_44843_((Enchantment)BzEnchantments.NEUROTOXINS.get(), (ItemStack)itemStack);
        if ((level = Math.min(level, BzGeneralConfigs.neurotoxinMaxLevel)) > 0 && victim instanceof LivingEntity && (livingEntity = (LivingEntity)victim).m_6336_() != MobType.f_21641_) {
            Optional<LivingEntityDataModule> capOptional;
            if (livingEntity.m_21023_(BzEffects.PARALYZED.get())) {
                return;
            }
            float applyChance = 1.0f;
            LivingEntityDataModule capability = null;
            if (attacker != null && (capOptional = ModuleHelper.getModule(attacker, ModuleRegistry.LIVING_ENTITY_DATA)).isPresent()) {
                capability = capOptional.orElseThrow(RuntimeException::new);
                float healthModifier = Math.max(100.0f - livingEntity.m_21223_(), 10.0f) / 100.0f;
                applyChance = healthModifier * (float)level * (float)(capability.getMissedParalysis() + 1);
            }
            if (livingEntity.m_217043_().m_188501_() < applyChance) {
                livingEntity.m_7292_(new MobEffectInstance(BzEffects.PARALYZED.get(), Math.min(100 * level, BzGeneralConfigs.paralyzedMaxTickDuration), level, false, true, true));
                if (attacker instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)attacker;
                    if (livingEntity instanceof Mob) {
                        Mob mob = (Mob)livingEntity;
                        mob.m_6703_(livingAttacker);
                        ((MobAccessor)mob).bumblezone$getTargetSelector().m_25373_();
                    }
                }
                if (itemStack.m_150930_(BzItems.STINGER_SPEAR.get()) && attacker instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)attacker;
                    BzCriterias.STINGER_SPEAR_PARALYZING_TRIGGER.trigger(serverPlayer);
                    if (livingEntity.m_21223_() > 70.0f) {
                        BzCriterias.STINGER_SPEAR_PARALYZE_BOSS_TRIGGER.trigger(serverPlayer);
                    }
                }
                if (capability != null) {
                    capability.setMissedParalysis(0);
                }
            } else if (capability != null) {
                capability.setMissedParalysis(capability.getMissedParalysis() + 1);
            }
        }
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_204117_(BzTags.ENCHANTABLE_NEUROTOXINS) || stack.m_150930_(Items.f_42517_);
    }

    @Override
    public OptionalBoolean bz$canApplyAtEnchantingTable(ItemStack stack) {
        return OptionalBoolean.of(this.m_6081_(stack));
    }
}

