/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.forge;

import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import net.minecraftforge.common.ForgeConfigSpec;

public class BzClientConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.DoubleValue fogBrightnessPercentage;
    public static ForgeConfigSpec.DoubleValue fogThickness;
    public static ForgeConfigSpec.BooleanValue enableDimensionFog;
    public static ForgeConfigSpec.BooleanValue useBackupModelForVariantBee;
    public static ForgeConfigSpec.BooleanValue playWrathOfHiveEffectMusic;
    public static ForgeConfigSpec.BooleanValue showBeeQueenSpeechBubble;
    public static ForgeConfigSpec.BooleanValue playSempiternalSanctumMusic;
    public static ForgeConfigSpec.BooleanValue disableEssenceBlockShaders;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightBosses;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightMonsters;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightTamed;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightLivingEntities;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightCommonItems;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightUncommonItems;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightRareItems;
    public static ForgeConfigSpec.BooleanValue knowingEssenceHighlightEpicItems;
    public static ForgeConfigSpec.BooleanValue knowingEssenceStructureNameClient;
    public static ForgeConfigSpec.IntValue knowingEssenceStructureNameXCoord;
    public static ForgeConfigSpec.IntValue knowingEssenceStructureNameYCoord;
    public static ForgeConfigSpec.BooleanValue radianceEssenceArmorDurability;
    public static ForgeConfigSpec.IntValue radianceEssenceArmorDurabilityXCoord;
    public static ForgeConfigSpec.IntValue radianceEssenceArmorDurabilityYCoord;
    public static ForgeConfigSpec.IntValue essenceItemHUDVisualEffectLayers;
    public static ForgeConfigSpec.DoubleValue essenceItemHUDVisualEffectSpeed;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("The Bumblezone Client Dimension Options");
        fogBrightnessPercentage = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How bright the fog is in the Bumblezone dimension. ", " ", " The brightness is represented as a percentage", " so 0 will be pitch black, 50 will be half", " as bright, 100 will be normal orange brightness,", " and 100000 will be white.\n"}).translation("the_bumblezone.config.fogbrightnesspercentage").defineInRange("fogBrightnessPercentage", 100.0, 0.0, 100000.0);
        fogThickness = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How thick the fog in Bumblezone is.", " 2 is a little bit of fog and 50 is super thick fog. Decimal values are allowed.\n"}).translation("the_bumblezone.config.fogthickness").defineInRange("fogThickness", 4.0, 0.0, 100.0);
        enableDimensionFog = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bumblezone dimension has thick fog or not.\n"}).translation("the_bumblezone.config.enabledimensionfog").define("enableDimensionFog", true);
        builder.pop();
        builder.push("Essence Item HUD Rendering Configs");
        essenceItemHUDVisualEffectLayers = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How many of the rotating texture layers to show on HUD when Essence item is in offhand slot.", " 0 to turn the rendering off.\n"}).translation("the_bumblezone.config.essenceitemhudvisualeffectlayers").defineInRange("essenceItemHUDVisualEffectLayers", 3, 0, 3);
        essenceItemHUDVisualEffectSpeed = builder.comment(new String[]{" \n-----------------------------------------------------\n", " How fast to spin the rotating texture layers on HUD when Essence item is in offhand slot.", " 0.5 for half speed. 0 to turn the spinning off.\n"}).translation("the_bumblezone.config.essenceitemhudvisualeffectspeed").defineInRange("essenceItemHUDVisualEffectSpeed", 1.0, 0.0, 100.0);
        builder.pop();
        builder.push("Knowing Essence Highlighting Configs (see block and entity tags for even more options)");
        knowingEssenceHighlightBosses = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight bosses in purple. (Does not override the forced highlighting entity tag)\n"}).translation("the_bumblezone.config.knowingEssenceHighlightBosses").define("knowingEssenceHighlightBosses", true);
        knowingEssenceHighlightMonsters = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight monsters in red. (Does not override the forced highlighting entity tag)\n"}).translation("the_bumblezone.config.knowingessencehighlightmonsters").define("knowingEssenceHighlightMonsters", true);
        knowingEssenceHighlightTamed = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight mobs you tamed in green. (Does not override the forced highlighting entity tag)\n"}).translation("the_bumblezone.config.knowingessencehighlighttamed").define("knowingEssenceHighlightTamed", true);
        knowingEssenceHighlightLivingEntities = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight any other mobs in orange. (Does not override the forced highlighting entity tag)\n"}).translation("the_bumblezone.config.knowingessencehighlightlivingentities").define("knowingEssenceHighlightLivingEntities", true);
        knowingEssenceHighlightCommonItems = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight common items in world in white color.\n"}).translation("the_bumblezone.config.knowingessencehighlightcommonitems").define("knowingEssenceHighlightCommonItems", true);
        knowingEssenceHighlightUncommonItems = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight uncommon items in world in yellow color.\n"}).translation("the_bumblezone.config.knowingessencehighlightuncommonitems").define("knowingEssenceHighlightUncommonItems", true);
        knowingEssenceHighlightRareItems = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight rare items in world in cyan color.\n"}).translation("the_bumblezone.config.knowingessencehighlightrareitems").define("knowingEssenceHighlightRareItems", true);
        knowingEssenceHighlightEpicItems = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will highlight epic items in world in purple color.\n"}).translation("the_bumblezone.config.knowingessencehighlightepicitems").define("knowingEssenceHighlightEpicItems", true);
        knowingEssenceStructureNameClient = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Knowing Essence will tell you the name of structures you are in.\n"}).translation("the_bumblezone.config.knowingessencestructurenameclient").define("knowingEssenceStructureNameClient", true);
        knowingEssenceStructureNameXCoord = builder.comment(new String[]{" \n-----------------------------------------------------\n", " X coordinate for where to render the structure name on screen. (Based on bottom left corner)\n"}).translation("the_bumblezone.config.knowingessencestructurenamexcoord").defineInRange("knowingEssenceStructureNameXCoord", 4, 0, 10000);
        knowingEssenceStructureNameYCoord = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Y coordinate for where to render the structure name on screen. (Based on bottom left corner)\n"}).translation("the_bumblezone.config.knowingessencestructurenameycoord").defineInRange("knowingEssenceStructureNameYCoord", 16, 0, 10000);
        builder.pop();
        builder.push("Radiance Essence configs");
        radianceEssenceArmorDurability = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Radiance Essence will show the durability of your armor.\n"}).translation("the_bumblezone.config.radianceessencearmordurability").define("radianceEssenceArmorDurability", true);
        radianceEssenceArmorDurabilityXCoord = builder.comment(new String[]{" \n-----------------------------------------------------\n", " X coordinate for where to render the armor durability on screen. (Based on bottom left corner)\n"}).translation("the_bumblezone.config.radianceessencearmordurabilityxcoord").defineInRange("radianceEssenceArmorDurabilityXCoord", 4, 0, 10000);
        radianceEssenceArmorDurabilityYCoord = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Y coordinate for where to render the armor durability on screen. (Based on bottom left corner)\n"}).translation("the_bumblezone.config.radianceessencearmordurabilityycoord").defineInRange("radianceEssenceArmorDurabilityYCoord", 16, 0, 10000);
        builder.pop();
        builder.push("Entity Model/Renderer configs");
        useBackupModelForVariantBee = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Turn this on if Variant Bee's model is messed up by another mod or resourcepack. Requires restart.\n"}).translation("the_bumblezone.config.usebackupmodelforvariantbee").define("useBackupModelForVariantBee", false);
        builder.pop();
        playWrathOfHiveEffectMusic = builder.comment(new String[]{" \n-----------------------------------------------------\n", " If on, Flight of the Bumblebee by Rimsky Korsakov will play when you have Wrath of the Hive effect on.\n"}).translation("the_bumblezone.config.playwrathofhiveeffectmusic").define("playWrathOfHiveEffectMusic", true);
        showBeeQueenSpeechBubble = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Display Bee Queen's speech bubble that shows possible trades you can do.\n"}).translation("the_bumblezone.config.showbeequeenspeechbubble").define("showBeeQueenSpeechBubble", true);
        playSempiternalSanctumMusic = builder.comment(new String[]{" \n-----------------------------------------------------\n", " If on, Bee-ware of the Temple by LudoCrypt will play when you are in Sempiternal Sanctum.\n"}).translation("the_bumblezone.config.playsempiternalsanctummusic").define("playSempiternalSanctumMusic", true);
        disableEssenceBlockShaders = builder.comment(" \n-----------------------------------------------------\n  Whether to not render the shader for Essence Blocks.\n  Will default to normal block textures instead.\n").translation("the_bumblezone.config.disableessenceblockshaders").define("disableEssenceBlockShaders", false);
    }

    public static void copyToCommon() {
        BzDimensionConfigs.fogBrightnessPercentage = (Double)fogBrightnessPercentage.get();
        BzDimensionConfigs.fogThickness = (Double)fogThickness.get();
        BzDimensionConfigs.enableDimensionFog = (Boolean)enableDimensionFog.get();
        BzClientConfigs.useBackupModelForVariantBee = (Boolean)useBackupModelForVariantBee.get();
        BzClientConfigs.playWrathOfHiveEffectMusic = (Boolean)playWrathOfHiveEffectMusic.get();
        BzClientConfigs.showBeeQueenSpeechBubble = (Boolean)showBeeQueenSpeechBubble.get();
        BzClientConfigs.playSempiternalSanctumMusic = (Boolean)playSempiternalSanctumMusic.get();
        BzClientConfigs.disableEssenceBlockShaders = (Boolean)disableEssenceBlockShaders.get();
        BzClientConfigs.knowingEssenceHighlightBosses = (Boolean)knowingEssenceHighlightBosses.get();
        BzClientConfigs.knowingEssenceHighlightMonsters = (Boolean)knowingEssenceHighlightMonsters.get();
        BzClientConfigs.knowingEssenceHighlightTamed = (Boolean)knowingEssenceHighlightTamed.get();
        BzClientConfigs.knowingEssenceHighlightLivingEntities = (Boolean)knowingEssenceHighlightLivingEntities.get();
        BzClientConfigs.knowingEssenceHighlightCommonItems = (Boolean)knowingEssenceHighlightCommonItems.get();
        BzClientConfigs.knowingEssenceHighlightUncommonItems = (Boolean)knowingEssenceHighlightUncommonItems.get();
        BzClientConfigs.knowingEssenceHighlightRareItems = (Boolean)knowingEssenceHighlightRareItems.get();
        BzClientConfigs.knowingEssenceHighlightEpicItems = (Boolean)knowingEssenceHighlightEpicItems.get();
        BzClientConfigs.knowingEssenceStructureNameClient = (Boolean)knowingEssenceStructureNameClient.get();
        BzClientConfigs.knowingEssenceStructureNameXCoord = (Integer)knowingEssenceStructureNameXCoord.get();
        BzClientConfigs.knowingEssenceStructureNameYCoord = (Integer)knowingEssenceStructureNameYCoord.get();
        BzClientConfigs.radianceEssenceArmorDurability = (Boolean)radianceEssenceArmorDurability.get();
        BzClientConfigs.radianceEssenceArmorDurabilityXCoord = (Integer)radianceEssenceArmorDurabilityXCoord.get();
        BzClientConfigs.radianceEssenceArmorDurabilityYCoord = (Integer)radianceEssenceArmorDurabilityYCoord.get();
        BzClientConfigs.essenceItemHUDVisualEffectLayers = (Integer)essenceItemHUDVisualEffectLayers.get();
        BzClientConfigs.essenceItemHUDVisualEffectSpeed = ((Double)essenceItemHUDVisualEffectSpeed.get()).floatValue();
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        BzClientConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

