/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.variantbee;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Bee;

public class BackupVariantBeeModel<T extends Bee>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_bumblezone", "variant_bee"), "main");
    private static final String BONE = "bone";
    private static final String STINGER = "stinger";
    private static final String LEFT_ANTENNA = "left_antenna";
    private static final String RIGHT_ANTENNA = "right_antenna";
    private static final String FRONT_LEGS = "front_legs";
    private static final String MIDDLE_LEGS = "middle_legs";
    private static final String BACK_LEGS = "back_legs";
    private final ModelPart bone;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart frontLeg;
    private final ModelPart midLeg;
    private final ModelPart backLeg;
    private final ModelPart stinger;
    private final ModelPart leftAntenna;
    private final ModelPart rightAntenna;
    private float rollAmount;

    public BackupVariantBeeModel(ModelPart modelPart) {
        super(false, 24.0f, 0.0f);
        this.bone = modelPart.m_171324_(BONE);
        ModelPart modelPart2 = this.bone.m_171324_("body");
        this.stinger = modelPart2.m_171324_(STINGER);
        this.leftAntenna = modelPart2.m_171324_(LEFT_ANTENNA);
        this.rightAntenna = modelPart2.m_171324_(RIGHT_ANTENNA);
        this.rightWing = this.bone.m_171324_("right_wing");
        this.leftWing = this.bone.m_171324_("left_wing");
        this.frontLeg = this.bone.m_171324_(FRONT_LEGS);
        this.midLeg = this.bone.m_171324_(MIDDLE_LEGS);
        this.backLeg = this.bone.m_171324_(BACK_LEGS);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition2 = partDefinition.m_171599_(BONE, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition partDefinition3 = partDefinition2.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -4.0f, -5.0f, 7.0f, 7.0f, 10.0f), PartPose.f_171404_);
        partDefinition3.m_171599_(STINGER, CubeListBuilder.m_171558_().m_171514_(26, 7).m_171481_(0.0f, -1.0f, 5.0f, 0.0f, 1.0f, 2.0f), PartPose.f_171404_);
        partDefinition3.m_171599_(LEFT_ANTENNA, CubeListBuilder.m_171558_().m_171514_(2, 0).m_171481_(1.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-5.0f));
        partDefinition3.m_171599_(RIGHT_ANTENNA, CubeListBuilder.m_171558_().m_171514_(2, 3).m_171481_(-2.5f, -2.0f, -3.0f, 1.0f, 2.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-5.0f));
        CubeDeformation cubeDeformation = new CubeDeformation(0.001f);
        partDefinition2.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-9.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, cubeDeformation), PartPose.m_171423_((float)-1.5f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        partDefinition2.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 9.0f, 0.0f, 6.0f, cubeDeformation), PartPose.m_171423_((float)1.5f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        partDefinition2.m_171599_(FRONT_LEGS, CubeListBuilder.m_171558_().m_171534_(FRONT_LEGS, -5.0f, 0.0f, 0.0f, 7, 2, 0, 26, 1), PartPose.m_171419_((float)1.5f, (float)3.0f, (float)-2.0f));
        partDefinition2.m_171599_(MIDDLE_LEGS, CubeListBuilder.m_171558_().m_171534_(MIDDLE_LEGS, -5.0f, 0.0f, 0.0f, 7, 2, 0, 26, 3), PartPose.m_171419_((float)1.5f, (float)3.0f, (float)0.0f));
        partDefinition2.m_171599_(BACK_LEGS, CubeListBuilder.m_171558_().m_171534_(BACK_LEGS, -5.0f, 0.0f, 0.0f, 7, 2, 0, 26, 5), PartPose.m_171419_((float)1.5f, (float)3.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void prepareMobModel(T bee, float f, float g, float h) {
        super.m_6839_(bee, f, g, h);
        this.rollAmount = bee.m_27935_(h);
        this.stinger.f_104207_ = !bee.m_27857_();
    }

    public void setupAnim(T bee, float f, float g, float h, float i, float j) {
        float k;
        boolean onGroundAndStill = bee.m_20096_() && bee.m_20184_().m_82556_() < 1.0E-7;
        this.rightWing.f_104203_ = 0.0f;
        this.leftAntenna.f_104203_ = 0.0f;
        this.rightAntenna.f_104203_ = 0.0f;
        this.bone.f_104203_ = 0.0f;
        if (onGroundAndStill) {
            this.rightWing.f_104204_ = -0.2618f;
            this.rightWing.f_104205_ = 0.0f;
            this.leftWing.f_104203_ = 0.0f;
            this.leftWing.f_104204_ = 0.2618f;
            this.leftWing.f_104205_ = 0.0f;
            this.frontLeg.f_104203_ = 0.0f;
            this.midLeg.f_104203_ = 0.0f;
            this.backLeg.f_104203_ = 0.0f;
        } else {
            k = h * 120.32113f * ((float)Math.PI / 180);
            this.rightWing.f_104204_ = 0.0f;
            this.rightWing.f_104205_ = Mth.m_14089_((float)k) * (float)Math.PI * 0.15f;
            this.leftWing.f_104203_ = this.rightWing.f_104203_;
            this.leftWing.f_104204_ = this.rightWing.f_104204_;
            this.leftWing.f_104205_ = -this.rightWing.f_104205_;
            this.frontLeg.f_104203_ = 0.7853982f;
            this.midLeg.f_104203_ = 0.7853982f;
            this.backLeg.f_104203_ = 0.7853982f;
            this.bone.f_104203_ = 0.0f;
            this.bone.f_104204_ = 0.0f;
            this.bone.f_104205_ = 0.0f;
        }
        if (!bee.m_21660_()) {
            this.bone.f_104203_ = 0.0f;
            this.bone.f_104204_ = 0.0f;
            this.bone.f_104205_ = 0.0f;
            if (!onGroundAndStill) {
                k = Mth.m_14089_((float)(h * 0.18f));
                this.bone.f_104203_ = 0.1f + k * (float)Math.PI * 0.025f;
                this.leftAntenna.f_104203_ = k * (float)Math.PI * 0.03f;
                this.rightAntenna.f_104203_ = k * (float)Math.PI * 0.03f;
                this.frontLeg.f_104203_ = -k * (float)Math.PI * 0.1f + 0.3926991f;
                this.backLeg.f_104203_ = -k * (float)Math.PI * 0.05f + 0.7853982f;
                this.bone.f_104201_ = 19.0f - Mth.m_14089_((float)(h * 0.18f)) * 0.9f;
            }
        }
        if (this.rollAmount > 0.0f) {
            this.bone.f_104203_ = ModelUtils.m_103125_((float)this.bone.f_104203_, (float)3.0915928f, (float)this.rollAmount);
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.bone);
    }
}

