/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.BumblezoneClient;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalShieldRenderer;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CosmicCrystalRenderer
extends LivingEntityRenderer<CosmicCrystalEntity, CosmicCrystalModel> {
    private static final ResourceLocation SKIN = new ResourceLocation("the_bumblezone", "textures/entity/cosmic_crystal.png");
    private static final ResourceLocation LASER_LOCATION = new ResourceLocation("the_bumblezone", "textures/entity/cosmic_crystal_laser.png");

    public CosmicCrystalRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CosmicCrystalModel(context.m_174023_(CosmicCrystalModel.LAYER_LOCATION)), 0.7f);
        this.m_115326_(new CosmicCrystalShieldRenderer((RenderLayerParent<CosmicCrystalEntity, CosmicCrystalModel>)this, context.m_174027_()));
    }

    public void render(CosmicCrystalEntity cosmicCrystalEntity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        this.renderLiving(cosmicCrystalEntity, entityYaw, partialTicks, stack, buffer, 0xF000F0);
        this.renderLaser(cosmicCrystalEntity, entityYaw, partialTicks, stack, buffer, 0xF000F0);
    }

    public void renderLiving(CosmicCrystalEntity cosmicCrystalEntity, float f, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.m_85836_();
        ((CosmicCrystalModel)this.f_115290_).f_102608_ = this.m_115342_(cosmicCrystalEntity, partialTick);
        ((CosmicCrystalModel)this.f_115290_).f_102609_ = cosmicCrystalEntity.m_20159_();
        ((CosmicCrystalModel)this.f_115290_).f_102610_ = cosmicCrystalEntity.m_6162_();
        float lerpedXRot = Mth.m_14189_((float)partialTick, (float)cosmicCrystalEntity.f_19860_, (float)cosmicCrystalEntity.m_146909_());
        float lerpedYRot = Mth.m_14189_((float)partialTick, (float)cosmicCrystalEntity.f_19859_, (float)cosmicCrystalEntity.m_146908_());
        float rotAxisDiff = lerpedYRot - lerpedXRot;
        float xRot = Mth.m_14179_((float)partialTick, (float)cosmicCrystalEntity.f_19860_, (float)cosmicCrystalEntity.m_146909_());
        this.setupRotations(cosmicCrystalEntity, poseStack, lerpedXRot, lerpedYRot, partialTick);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_(cosmicCrystalEntity, poseStack, partialTick);
        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
        float n = 0.0f;
        float o = 0.0f;
        if (!cosmicCrystalEntity.m_20159_() && cosmicCrystalEntity.m_6084_()) {
            n = cosmicCrystalEntity.f_267362_.m_267711_(partialTick);
            o = cosmicCrystalEntity.f_267362_.m_267590_(partialTick);
            if (n > 1.0f) {
                n = 1.0f;
            }
        }
        float tickTimeWithPartial = this.m_6930_(cosmicCrystalEntity, partialTick);
        ((CosmicCrystalModel)this.f_115290_).m_6839_((Entity)cosmicCrystalEntity, o, n, partialTick);
        ((CosmicCrystalModel)this.f_115290_).setupAnim(cosmicCrystalEntity, o, n, tickTimeWithPartial, rotAxisDiff, xRot);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl = this.m_5933_(cosmicCrystalEntity);
        boolean bl2 = !bl && !cosmicCrystalEntity.m_20177_((Player)minecraft.f_91074_);
        boolean bl3 = minecraft.m_91314_((Entity)cosmicCrystalEntity);
        RenderType renderType = this.m_7225_(cosmicCrystalEntity, bl, bl2, bl3);
        if (renderType != null) {
            float currentHealthState;
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(renderType);
            int overlayCoords = LivingEntityRenderer.m_115338_((LivingEntity)cosmicCrystalEntity, (float)this.m_6931_(cosmicCrystalEntity, partialTick));
            float red = currentHealthState = Math.min(1.0f, Math.min(1.0f, cosmicCrystalEntity.m_21223_() / cosmicCrystalEntity.m_21233_()) * 0.45f + 0.6f);
            float green = currentHealthState;
            float blue = currentHealthState;
            if (cosmicCrystalEntity.m_146888_() > 0) {
                red *= 0.75f;
                green *= 0.75f;
            }
            if (cosmicCrystalEntity.m_6060_()) {
                green *= 0.75f;
                blue *= 0.75f;
            }
            for (MobEffect mobEffect : new HashSet(cosmicCrystalEntity.m_21221_().keySet())) {
                String namespace;
                if (mobEffect == MobEffects.f_19614_) {
                    red *= 0.75f;
                    blue *= 0.75f;
                    continue;
                }
                if (mobEffect == MobEffects.f_19615_) {
                    red *= 0.5f;
                    green *= 0.5f;
                    blue *= 0.5f;
                    continue;
                }
                if (mobEffect.m_8093_() || mobEffect.m_19486_() || (namespace = BuiltInRegistries.f_256974_.m_7981_((Object)mobEffect).m_135827_()).equals("minecraft") || namespace.equals("the_bumblezone")) continue;
                red = (red + (float)GeneralUtils.getRed(mobEffect.m_19484_()) / 255.0f) / 2.0f;
                green = (green + (float)GeneralUtils.getGreen(mobEffect.m_19484_()) / 255.0f) / 2.0f;
                blue = (blue + (float)GeneralUtils.getBlue(mobEffect.m_19484_()) / 255.0f) / 2.0f;
            }
            this.f_115290_.m_7695_(poseStack, vertexConsumer, packedLight, overlayCoords, red, green, blue, bl2 ? 0.15f : 1.0f);
        }
        if (!cosmicCrystalEntity.m_5833_()) {
            for (RenderLayer renderLayer : this.f_115291_) {
                renderLayer.m_6494_(poseStack, multiBufferSource, packedLight, (Entity)cosmicCrystalEntity, o, n, partialTick, tickTimeWithPartial, rotAxisDiff, xRot);
            }
        }
        poseStack.m_85849_();
    }

    protected void renderHealth(Entity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (this.f_114476_.m_114471_(entity) > 100.0) {
            return;
        }
        float f = entity.m_278726_() + 0.5f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, f, 0.0f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float g = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int k = (int)(g * 255.0f) << 24;
        Font font = this.m_114481_();
        float h = (float)(-font.m_92852_((FormattedText)component)) / 2.0f;
        font.m_272077_(component, h, 0.0f, 0x20FFFFFF, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, k, packedLight);
        font.m_272077_(component, h, 0.0f, -1, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }

    protected void setupRotations(CosmicCrystalEntity cosmicCrystalEntity, PoseStack poseStack, float lerpedXRot, float lerpedYRot, float partialTick) {
        if (this.m_5936_(cosmicCrystalEntity)) {
            lerpedXRot += (float)(Math.cos((double)cosmicCrystalEntity.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - lerpedYRot));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f - lerpedXRot));
        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
    }

    public void renderLaser(CosmicCrystalEntity cosmicCrystalEntity, float f, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (cosmicCrystalEntity.isLaserFiring()) {
            float totalTickTime = (float)cosmicCrystalEntity.f_19797_ + partialTick;
            float colorSpeed = -5.0f;
            long uniqueValue = cosmicCrystalEntity.m_20148_().getLeastSignificantBits() % 1000000L;
            float radianColor = (totalTickTime * colorSpeed + (float)uniqueValue) % 360.0f * ((float)Math.PI / 180);
            int baseBrightness = 200;
            int colorStrength = 55;
            float redSin = Mth.m_14031_((float)radianColor);
            float greenSin = Mth.m_14031_((float)(radianColor + 30.0f));
            float blueSin = Mth.m_14031_((float)(radianColor + 60.0f));
            int red = baseBrightness + (int)(redSin * (float)colorStrength);
            int green = baseBrightness + (int)(greenSin * (float)colorStrength);
            int blue = baseBrightness + (int)(blueSin * (float)colorStrength);
            float redSin2 = Mth.m_14089_((float)radianColor);
            float greenSin2 = Mth.m_14089_((float)(radianColor + 30.0f));
            float blueSin2 = Mth.m_14089_((float)(radianColor + 60.0f));
            int red2 = baseBrightness + (int)(redSin2 * (float)colorStrength);
            int green2 = baseBrightness + (int)(greenSin2 * (float)colorStrength);
            int blue2 = baseBrightness + (int)(blueSin2 * (float)colorStrength);
            float eyeY = cosmicCrystalEntity.m_20192_();
            poseStack.m_85836_();
            Vec3 startPos = cosmicCrystalEntity.m_146892_();
            Vec3 prevLookAngle = cosmicCrystalEntity.prevLookAngle;
            Vec3 lookAngle = cosmicCrystalEntity.m_20154_();
            Vec3 lerpedLook = new Vec3(Mth.m_14139_((double)partialTick, (double)prevLookAngle.m_7096_(), (double)lookAngle.m_7096_()), Mth.m_14139_((double)partialTick, (double)prevLookAngle.m_7098_(), (double)lookAngle.m_7098_()), Mth.m_14139_((double)partialTick, (double)prevLookAngle.m_7094_(), (double)lookAngle.m_7094_()));
            Vec3 endPos = lerpedLook.m_82490_(50.0).m_82549_(startPos);
            BlockHitResult hitResult = cosmicCrystalEntity.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)cosmicCrystalEntity));
            if (hitResult.m_6662_() != HitResult.Type.MISS) {
                endPos = hitResult.m_82450_().m_82546_(lookAngle);
            }
            Vec3 vectToTarget = endPos.m_82546_(startPos);
            float laserLength = (float)vectToTarget.m_82553_() - 0.01f;
            vectToTarget = vectToTarget.m_82541_();
            float n = (float)Math.acos(vectToTarget.f_82480_);
            float o = (float)Math.atan2(vectToTarget.f_82481_, vectToTarget.f_82479_);
            poseStack.m_85837_(lookAngle.m_7096_(), (double)eyeY + lookAngle.m_7098_(), lookAngle.m_7094_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - o) * 57.295776f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(n * 57.295776f));
            float q = totalTickTime * 0.05f * -1.5f;
            float v = 0.2f;
            float w2 = 0.5f;
            float z5 = Mth.m_14031_((float)(q + 2.3561945f)) * w2;
            float x7 = Mth.m_14089_((float)(q + 2.3561945f)) * w2;
            float z9 = Mth.m_14089_((float)(q + 0.7853982f)) * w2;
            float z6 = Mth.m_14031_((float)(q + 0.7853982f)) * w2;
            float x6 = Mth.m_14089_((float)(q + 3.926991f)) * w2;
            float z8 = Mth.m_14031_((float)(q + 3.926991f)) * w2;
            float x5 = Mth.m_14089_((float)(q + 5.4977875f)) * w2;
            float z7 = Mth.m_14031_((float)(q + 5.4977875f)) * w2;
            float x1 = Mth.m_14089_((float)(q + (float)Math.PI)) * v;
            float z1 = Mth.m_14031_((float)(q + (float)Math.PI)) * v;
            float x2 = Mth.m_14089_((float)(q + 0.0f)) * v;
            float z2 = Mth.m_14031_((float)(q + 0.0f)) * v;
            float x3 = Mth.m_14089_((float)(q + 1.5707964f)) * v;
            float z3 = Mth.m_14031_((float)(q + 1.5707964f)) * v;
            float x4 = Mth.m_14089_((float)(q + 4.712389f)) * v;
            float z4 = Mth.m_14031_((float)(q + 4.712389f)) * v;
            float y1 = laserLength;
            float y2 = 0.0f;
            float ux1 = 0.4999f;
            float ux2 = 0.0f;
            float uv2 = -1.0f + totalTickTime * -0.2f % 1.0f;
            float uv1 = laserLength * 2.5f + uv2;
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(BumblezoneClient.ENTITY_CUTOUT_EMISSIVE_RENDER_TYPE.apply(LASER_LOCATION));
            PoseStack.Pose pose = poseStack.m_85850_();
            Matrix4f matrix4f = pose.m_252922_();
            Matrix3f matrix3f = pose.m_252943_();
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x1, y1, z1, red2, green2, blue2, ux1, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x1, y2, z1, red, green, blue, ux1, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x2, y2, z2, red, green, blue, ux2, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x2, y1, z2, red2, green2, blue2, ux2, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x3, y1, z3, red2, green2, blue2, ux1, uv1);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x3, y2, z3, red, green, blue, ux1, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x4, y2, z4, red, green, blue, ux2, uv2);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x4, y1, z4, red2, green2, blue2, ux2, uv1);
            float as = 0.0f;
            if (cosmicCrystalEntity.f_19797_ % 4 < 2) {
                as = 0.5f;
            }
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x7, y1, z5, red2, green2, blue2, 0.5f, as + 0.5f);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, z9, y1, z6, red2, green2, blue2, 1.0f, as + 0.5f);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x5, y1, z7, red2, green2, blue2, 1.0f, as);
            CosmicCrystalRenderer.vertex(vertexConsumer, matrix4f, matrix3f, x6, y1, z8, red2, green2, blue2, 0.5f, as);
            poseStack.m_85849_();
            CosmicCrystalRenderer.laserScreenShake(cosmicCrystalEntity, endPos);
        }
    }

    private static void laserScreenShake(CosmicCrystalEntity cosmicCrystalEntity, Vec3 endPos) {
        double threshold;
        double distance2;
        double distance1;
        double minDistance;
        Entity camera = Minecraft.m_91087_().m_91288_();
        if (camera != null && (minDistance = Math.min(distance1 = cosmicCrystalEntity.m_20182_().m_82554_(camera.m_20182_()), distance2 = endPos.m_82554_(camera.m_20182_()))) <= (threshold = 10.0)) {
            double percentageToCenter = 1.0 - minDistance / threshold;
            double spinSlowdown = 0.15 + 0.3 * (1.0 - percentageToCenter * percentageToCenter);
            float intensity = (float)(0.175 * percentageToCenter * percentageToCenter * percentageToCenter);
            double currentMillisecond = (double)System.currentTimeMillis() % (360.0 * spinSlowdown);
            double degrees = currentMillisecond / spinSlowdown;
            float angle = (float)(degrees * 0.01745329238474369);
            camera.m_146922_(camera.m_146908_() + Mth.m_14031_((float)angle) * intensity);
        }
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float x, float y, float z, int red, int green, int blue, float ux, float uz) {
        vertexConsumer.m_252986_(matrix4f, x, y, z).m_6122_(red, green, blue, 255).m_7421_(ux, uz).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(CosmicCrystalEntity cosmicCrystalEntity) {
        return SKIN;
    }

    protected boolean shouldShowName(CosmicCrystalEntity entity) {
        return false;
    }
}

