/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.client.ParticleEngineAccessor;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class TradeHintParticle
extends Particle {
    public static final int TRADE_REWARD_CYCLE_TIME = 40;
    public static final double PARTICLE_Y_OFFSET = 4.5;
    public static final ResourceLocation SPEECH_BUBBLE_TEXTURE = new ResourceLocation("the_bumblezone", "trade_hint/1");
    private final RenderBuffers renderBuffers;
    private final ItemRenderer itemRenderer;
    private final Item tradeWantItem;
    private final List<Item> tradeRewardItems;
    protected TextureAtlasSprite sprite;
    private int life;
    private float pastAnimationProgress;

    public TradeHintParticle(ItemRenderer itemRenderer, RenderBuffers arg2, ClientLevel arg3, Entity queen, Item tradeWantItem, List<Item> tradeRewardItems) {
        super(arg3, queen.m_20185_(), queen.m_20186_() + 4.5, queen.m_20189_(), 0.0, 0.0, 0.0);
        this.renderBuffers = arg2;
        this.tradeWantItem = tradeWantItem;
        this.tradeRewardItems = tradeRewardItems;
        this.itemRenderer = itemRenderer;
        this.sprite = ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).bumblezone$getTextureAtlas().m_118316_(SPEECH_BUBBLE_TEXTURE);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(VertexConsumer doNotUse, Camera camera, float partialTick) {
        Quaternionf cameraRotationQuat;
        float animationProgress;
        if (!BzClientConfigs.showBeeQueenSpeechBubble) {
            return;
        }
        this.pastAnimationProgress = animationProgress = this.getAnimationProgressForCurrentLife(partialTick);
        if (this.f_107231_ == 0.0f) {
            cameraRotationQuat = camera.m_253121_();
        } else {
            cameraRotationQuat = new Quaternionf((Quaternionfc)camera.m_253121_());
            cameraRotationQuat.rotateZ(Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_));
        }
        float offset = 1.0f - animationProgress;
        Vector3f offsetVec = new Vector3f(-offset, -offset, 0.0f);
        offsetVec.rotate((Quaternionfc)cameraRotationQuat);
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_()) + offsetVec.x();
        float y = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_()) + offsetVec.y();
        float z = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_()) + offsetVec.z();
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f = vector3fs[k];
            vector3f.rotate((Quaternionfc)cameraRotationQuat);
            vector3f.mul(animationProgress);
            vector3f.add(x, y, z);
        }
        float u0 = this.sprite.m_118409_();
        float u1 = this.sprite.m_118410_();
        float v0 = this.sprite.m_118411_();
        float v1 = this.sprite.m_118412_();
        int lightColor = 240;
        MultiBufferSource.BufferSource bufferSource = this.renderBuffers.m_110104_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)TextureAtlas.f_118260_));
        vertexConsumer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u1, v1).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u1, v0).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u0, v0).m_85969_(lightColor).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u0, v1).m_85969_(lightColor).m_5752_();
        bufferSource.m_109911_();
        Quaternionf reverseQuad = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        reverseQuad.rotateAxis((float)Math.PI, 0.0f, 1.0f, 0.0f);
        Quaternionf normalToUse = new Quaternionf(-0.8f, 0.0f, 0.0f, 1.0f);
        PoseStack wantPoseStack = new PoseStack();
        TradeHintParticle.setupPoseStack(wantPoseStack, x, y, z, 0.35f, 0.437f, -0.001f, animationProgress, cameraRotationQuat, reverseQuad, normalToUse);
        ItemStack wantItemStack = this.tradeWantItem.m_7968_();
        this.renderItem(wantItemStack, wantPoseStack, bufferSource);
        PoseStack rewardPoseStack = new PoseStack();
        TradeHintParticle.setupPoseStack(rewardPoseStack, x, y, z, -0.32f, -0.15f, -0.001f, animationProgress, cameraRotationQuat, reverseQuad, normalToUse);
        ItemStack rewardItemStack = this.tradeRewardItems.get(this.life / 40 % this.tradeRewardItems.size()).m_7968_();
        this.renderItem(rewardItemStack, rewardPoseStack, bufferSource);
        rewardPoseStack.m_85849_();
        bufferSource.m_109911_();
    }

    private static void setupPoseStack(PoseStack poseStack, float x, float y, float z, float xOffset, float yOffset, float zOffset, float size, Quaternionf quaternionf, Quaternionf reverseQuad, Quaternionf normalToUse) {
        poseStack.m_85836_();
        poseStack.m_85850_().m_252922_().translate(x, y, z);
        poseStack.m_85850_().m_252922_().scale(size, size, size);
        poseStack.m_85850_().m_252922_().rotateAround((Quaternionfc)quaternionf, 0.0f, 0.0f, 0.0f);
        poseStack.m_85850_().m_252922_().translate(xOffset, yOffset, zOffset);
        poseStack.m_85850_().m_252922_().scale(0.5f, 0.5f, 0.001f);
        poseStack.m_85850_().m_252922_().rotateAround((Quaternionfc)reverseQuad, 0.0f, 0.0f, 0.0f);
        poseStack.m_85850_().m_252943_().set((Quaternionfc)normalToUse);
    }

    private float getAnimationProgressForCurrentLife(float partialTick) {
        float animationProgress = 1.0f;
        float animationChangeTime = 20.0f;
        if ((float)this.life <= animationChangeTime) {
            float currentProgress = (float)this.life / animationChangeTime;
            float c1 = 1.70158f;
            float c3 = c1 + 1.0f;
            float calcSize = (float)(1.0 + (double)c3 * Math.pow(currentProgress - 1.0f, 3.0) + (double)c1 * Math.pow(currentProgress - 1.0f, 2.0));
            animationProgress = Mth.m_14179_((float)partialTick, (float)this.pastAnimationProgress, (float)calcSize);
        } else if ((float)(200 - this.life) <= animationChangeTime / 2.0f) {
            float currentProgress = (float)(200 - this.life) / (animationChangeTime / 2.0f);
            float calcSize = (float)(1.0 - Math.cos((double)currentProgress * Math.PI / 2.0));
            animationProgress = Mth.m_14179_((float)partialTick, (float)this.pastAnimationProgress, (float)calcSize);
        }
        return animationProgress;
    }

    private void renderItem(ItemStack itemStack, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        BakedModel bakedmodel = this.itemRenderer.m_174264_(itemStack, (Level)Minecraft.m_91087_().f_91073_, null, 0);
        this.itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
    }

    public void m_5989_() {
        ++this.life;
        if (this.life == 200) {
            this.m_107274_();
        }
    }
}

