/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationAxisBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);

    protected RotationAxisBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        int rotationIndex = (Integer)state.m_61143_((Property)ROTATION);
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        BlockState newState = RotatedPillarBlock.m_154376_((BlockState)state, (Rotation)rotation);
        int newRotationIndex = RotationAxisBlock.getRotatedRotation(axis, rotationIndex, rotation);
        return (BlockState)newState.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getRotatedRotation(Direction.Axis axis, int rotationIndex, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            if ((axis != Direction.Axis.Z || i % 2 != 1) && (axis != Direction.Axis.X || i % 2 != 0)) continue;
            if (rotationIndex % 2 == 0) {
                ++rotationIndex;
                continue;
            }
            --rotationIndex;
        }
        return rotationIndex;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        int rotationIndex = (Integer)state.m_61143_((Property)ROTATION);
        int newRotationIndex = RotationAxisBlock.getMirroredRotation(axis, rotationIndex, mirror);
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getMirroredRotation(Direction.Axis axis, int rotationIndex, Mirror mirror) {
        boolean rotationIsEven;
        if (mirror == Mirror.NONE) {
            return rotationIndex;
        }
        boolean specialCase = mirror == Mirror.LEFT_RIGHT && axis != Direction.Axis.Y;
        boolean bl = rotationIsEven = rotationIndex % 2 == 0;
        if (specialCase && rotationIsEven || !specialCase && !rotationIsEven) {
            return (rotationIndex + 2) % 4;
        }
        return rotationIndex;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
        builder.m_61104_(new Property[]{ROTATION});
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction clickFaceDirection = blockPlaceContext.m_43719_();
        Direction horizontalDirection = blockPlaceContext.m_8125_();
        Direction.Axis axis = Direction.Axis.Y;
        int rotation = 0;
        if (clickFaceDirection.m_122434_() == Direction.Axis.Y) {
            axis = horizontalDirection.m_122434_();
            if (horizontalDirection == Direction.SOUTH || horizontalDirection == Direction.WEST) {
                rotation = 1;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation));
    }
}

