/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.api.recipe.category;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public interface IRecipeCategory<T> {
    public RecipeType<T> getRecipeType();

    public Component getTitle();

    @Deprecated(since="15.20.0", forRemoval=true)
    @Nullable
    default public IDrawable getBackground() {
        return null;
    }

    default public int getWidth() {
        IDrawable background = this.getBackground();
        if (background == null) {
            throw new IllegalStateException("getWidth() and getHeight() must be overridden if background is null");
        }
        return background.getWidth();
    }

    default public int getHeight() {
        IDrawable background = this.getBackground();
        if (background == null) {
            throw new IllegalStateException("getWidth() and getHeight() must be overridden if background is null");
        }
        return background.getHeight();
    }

    @Nullable
    public IDrawable getIcon();

    public void setRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);

    default public void createRecipeExtras(IRecipeExtrasBuilder builder, T recipe, IFocusGroup focuses) {
    }

    default public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
    }

    default public void onDisplayedIngredientsUpdate(T recipe, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
    }

    @Deprecated(since="15.8.4", forRemoval=true)
    default public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return List.of();
    }

    default public void getTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        List<Component> tooltipStrings = this.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
        tooltip.addAll(tooltipStrings);
    }

    @Deprecated(since="15.9.0", forRemoval=true)
    default public boolean handleInput(T recipe, double mouseX, double mouseY, InputConstants.Key input) {
        return false;
    }

    default public boolean isHandled(T recipe) {
        return true;
    }

    @Nullable
    default public ResourceLocation getRegistryName(T recipe) {
        if (recipe instanceof Recipe) {
            Recipe vanillaRecipe = (Recipe)recipe;
            return vanillaRecipe.m_6423_();
        }
        return null;
    }
}

