/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.UnknownType;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.TriggerLink;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.joml.Vector3f;

public class TypeAdapter {
    static Map<convertion, Function> adapters = Collections.synchronizedMap(new HashMap());
    static Set<convertion> incompatibleTypes = Collections.synchronizedSet(new HashSet());
    static Map<Class, Integer> typeColorMap = Collections.synchronizedMap(new HashMap());
    static Map<Class, String> typeDisplayNameMap = Collections.synchronizedMap(new HashMap());
    static Set<Class> castTypes = Collections.synchronizedSet(new HashSet());
    static boolean adaptersLoaded = false;

    public static <F, T> void registerAdapter(Class<F> from, Class<T> to, Function<F, T> adapter) {
        adapters.put(new convertion(from, to), adapter);
        TypeAdapter.registerCastType(from);
        TypeAdapter.registerCastType(to);
    }

    public static void registerTypeColor(Class<?> clazz, int color) {
        typeColorMap.put(clazz, color);
        TypeAdapter.registerCastType(clazz);
    }

    public static void registerTypeDisplayName(Class<?> clazz, String name) {
        typeDisplayNameMap.put(clazz, name);
        TypeAdapter.registerCastType(clazz);
    }

    public static void registerIncompatibleTypes(Class from, Class to) {
        incompatibleTypes.add(new convertion(from, to));
    }

    public static void registerCastType(Class<?> clazz) {
        castTypes.add(clazz);
    }

    public static void loadAllAdapters() {
        adaptersLoaded = true;
        AnnotationDetector.REGISTER_TYPE_ADAPTERS.forEach(instance -> {
            instance.onRegister();
            Class<?> clazz = instance.getClass();
            for (Method method : clazz.getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || method.getReturnType() == Void.TYPE || method.getParameterCount() != 1) continue;
                Class<?> from = method.getParameterTypes()[0];
                Class<?> to = method.getReturnType();
                adapters.put(new convertion(from, to), obj -> {
                    try {
                        return method.invoke(instance, obj);
                    }
                    catch (Exception e) {
                        return null;
                    }
                });
            }
        });
    }

    public static boolean areIncompatible(Class from, Class to) {
        if (!adaptersLoaded) {
            TypeAdapter.loadAllAdapters();
        }
        return incompatibleTypes.stream().anyMatch(t -> t.from == from && t.to == to);
    }

    public static boolean areConvertable(Class from, Class to) {
        if (!adaptersLoaded) {
            TypeAdapter.loadAllAdapters();
        }
        if (from == to || to == Object.class) {
            return true;
        }
        if (TypeAdapter.areIncompatible(from, to)) {
            return false;
        }
        return adapters.containsKey(new convertion(from, to));
    }

    public static Object convert(Object from, Class targetType) {
        if (!adaptersLoaded) {
            TypeAdapter.loadAllAdapters();
        }
        convertion convertion2 = new convertion(from.getClass(), targetType);
        if (convertion2.from == convertion2.to || convertion2.to == Object.class) {
            return from;
        }
        if (adapters.containsKey(convertion2)) {
            return adapters.get(convertion2).apply(from);
        }
        return null;
    }

    public static String getTypeDisplayName(Class<?> type) {
        if (!adaptersLoaded) {
            TypeAdapter.loadAllAdapters();
        }
        if (type == TriggerLink.class) {
            return "Trigger";
        }
        if (type == Float.TYPE || type == Integer.TYPE || type == Float.class || type == Integer.class) {
            return "Number";
        }
        if (type == Object.class) {
            return "Any";
        }
        return typeDisplayNameMap.getOrDefault(type, type.getSimpleName());
    }

    public static int getTypeColor(Class<?> type) {
        if (!adaptersLoaded) {
            TypeAdapter.loadAllAdapters();
        }
        if (type == UnknownType.class) {
            return ColorPattern.generateRainbowColor();
        }
        if (type == TriggerLink.class) {
            return ColorPattern.YELLOW.color;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ColorPattern.PINK.color;
        }
        if (type.isPrimitive() || type == Integer.class || type == Float.class) {
            return ColorPattern.LIGHT_BLUE.color;
        }
        if (type == String.class) {
            return ColorPattern.BROWN.color;
        }
        if (type == Object.class) {
            return ColorPattern.WHITE.color;
        }
        if (type == Vector3f.class) {
            return ColorPattern.ORANGE.color;
        }
        return typeColorMap.getOrDefault(type, ColorPattern.BLUE.color);
    }

    public record convertion(Class from, Class to) {
    }

    public static interface ITypeAdapter {
        public void onRegister();
    }
}

