/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class FileUtility {
    public static final JsonParser jsonParser = new JsonParser();
    public static final Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().create();

    private FileUtility() {
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        byte[] streamData = IOUtils.toByteArray((InputStream)inputStream);
        return new String(streamData, StandardCharsets.UTF_8);
    }

    public static InputStream writeInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
    }

    public static JsonObject tryExtractFromFile(Path filePath) {
        JsonObject jsonObject;
        block8: {
            InputStream fileStream = Files.newInputStream(filePath, new OpenOption[0]);
            try {
                InputStreamReader streamReader = new InputStreamReader(fileStream);
                jsonObject = jsonParser.parse((Reader)streamReader).getAsJsonObject();
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            fileStream.close();
        }
        return jsonObject;
    }

    public static JsonElement loadJson(File file) {
        try {
            if (!file.isFile()) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            JsonElement json = jsonParser.parse(new JsonReader((Reader)reader));
            ((Reader)reader).close();
            return json;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean saveJson(File file, JsonElement element) {
        try {
            if (!file.getParentFile().isDirectory()) {
                file.getParentFile().mkdirs();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            writer.write(GSON_PRETTY.toJson(element));
            ((Writer)writer).close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractJarFiles(String resource, File targetPath, boolean replace) {
        FileSystem zipFileSystem = null;
        try {
            Path resourcePath;
            URI sampleUri = FileUtility.class.getResource("/assets/gregtech/.gtassetsroot").toURI();
            if (sampleUri.getScheme().equals("jar") || sampleUri.getScheme().equals("zip")) {
                zipFileSystem = FileSystems.newFileSystem(sampleUri, Collections.emptyMap());
                resourcePath = zipFileSystem.getPath(resource, new String[0]);
            } else {
                if (!sampleUri.getScheme().equals("file")) throw new IllegalStateException("Unable to locate absolute path to directory: " + String.valueOf(sampleUri));
                resourcePath = Paths.get(FileUtility.class.getResource(resource).toURI());
            }
            List jarFiles = Files.walk(resourcePath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            for (Path jarFile : jarFiles) {
                Path genPath = targetPath.toPath().resolve(resourcePath.relativize(jarFile).toString());
                Files.createDirectories(genPath.getParent(), new FileAttribute[0]);
                if (!replace && genPath.toFile().isFile()) continue;
                Files.copy(jarFile, genPath, StandardCopyOption.REPLACE_EXISTING);
            }
            if (zipFileSystem == null) return;
        }
        catch (IOException | URISyntaxException exception) {
            if (zipFileSystem == null) return;
            IOUtils.closeQuietly(zipFileSystem);
            return;
            catch (Throwable throwable) {
                if (zipFileSystem == null) throw throwable;
                IOUtils.closeQuietly(zipFileSystem);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)zipFileSystem);
        return;
    }
}

