/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomResourcePack
extends PathPackResources {
    private final PackType type;
    private final String namespace;

    public CustomResourcePack(File location, String namespace, PackType type) {
        super(namespace, location.toPath(), false);
        new File(location, "assets/" + namespace).mkdirs();
        this.namespace = namespace;
        this.type = type;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... pathSegments) {
        String fileName = String.join((CharSequence)"/", pathSegments);
        if ("pack.mcmeta".equals(fileName)) {
            String description = "Generated resources for " + this.namespace;
            String fallback = "Mod resources.";
            String pack = String.format("{\"pack\":{\"pack_format\":" + SharedConstants.m_183709_().m_264084_(this.type) + ",\"description\":{\"translate\":\"%s\",\"fallback\":\"%s.\"}}}", description, fallback);
            return () -> IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
        }
        return super.m_8017_(pathSegments);
    }
}

