/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlockTypeAdapterFactory
implements TypeAdapterFactory {
    public static final BlockTypeAdapterFactory INSTANCE = new BlockTypeAdapterFactory();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Block.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        return new BlockTypeAdapter(gson);
    }

    private static final class BlockTypeAdapter
    extends TypeAdapter<Block> {
        private final Gson gson;

        private BlockTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, Block value) {
            if (value == null) {
                this.gson.toJson((JsonElement)JsonNull.INSTANCE, out);
                return;
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", BuiltInRegistries.f_256975_.m_7981_((Object)value).toString());
            this.gson.toJson((JsonElement)jsonObject, out);
        }

        public Block read(JsonReader in) {
            JsonElement jsonElement = (JsonElement)this.gson.fromJson(in, JsonElement.class);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            return (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(jsonElement.getAsJsonObject().get("id").getAsString()));
        }
    }
}

