/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.base.Preconditions;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.animation.Animation;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.modular.WidgetUIAccess;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Align;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.platform.InputConstants;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@RemapPrefixForJS(value="kjs$")
@Configurable(name="ldlib.gui.editor.group.basic_info", collapse=false)
public class Widget {
    protected ModularUI gui;
    protected WidgetUIAccess uiAccess;
    @Configurable(tips={"ldlib.gui.editor.tips.id"})
    protected String id = "";
    private Position parentPosition = Position.ORIGIN;
    @Configurable(name="ldlib.gui.editor.name.pos", tips={"ldlib.gui.editor.tips.pos"})
    private Position selfPosition;
    private Position position;
    @Configurable(name="ldlib.gui.editor.name.size")
    private Size size;
    @Configurable(name="ldlib.gui.editor.name.align", tips={"ldlib.gui.editor.tips.align"})
    private Align align = Align.NONE;
    private boolean isVisible;
    private boolean isActive;
    private boolean isFocus;
    protected boolean isClientSideWidget;
    @Configurable(name="ldlib.gui.editor.name.hover_tips", tips={"ldlib.gui.editor.tips.hover_tips"})
    protected final List<Component> tooltipTexts = new ArrayList<Component>();
    @Configurable(name="ldlib.gui.editor.name.background")
    protected IGuiTexture backgroundTexture;
    @Configurable(name="ldlib.gui.editor.name.draw_background_when_hover")
    protected boolean drawBackgroundWhenHover = true;
    @Configurable(name="ldlib.gui.editor.name.hover_texture")
    protected IGuiTexture hoverTexture;
    @Configurable(name="ldlib.gui.editor.name.overlayTexture")
    protected IGuiTexture overlay;
    protected WidgetGroup parent;
    protected Animation animation;
    protected boolean initialized;
    protected boolean tryToDrag = false;
    protected Supplier<Object> draggingProvider;
    protected BiFunction<Object, Position, IGuiTexture> draggingRenderer;
    protected Predicate<Object> draggingAccept = o -> false;
    protected Consumer<Object> draggingIn;
    protected Consumer<Object> draggingOut;
    protected Consumer<Object> draggingSuccess;
    protected Object draggingElement;

    public Widget(Position selfPosition, Size size) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.selfPosition = selfPosition;
        this.size = size;
        this.position = this.parentPosition.add(selfPosition);
        this.isVisible = true;
        this.isActive = true;
    }

    public Widget(int x, int y, int width, int height) {
        this(new Position(x, y), new Size(width, height));
    }

    public Widget setClientSideWidget() {
        this.isClientSideWidget = true;
        return this;
    }

    @HideFromJS
    public Widget setHoverTooltips(String ... tooltipText) {
        this.tooltipTexts.clear();
        this.appendHoverTooltips(tooltipText);
        return this;
    }

    @HideFromJS
    public Widget setHoverTooltips(Component ... tooltipText) {
        this.tooltipTexts.clear();
        this.appendHoverTooltips(tooltipText);
        return this;
    }

    @HideFromJS
    public Widget setHoverTooltips(List<Component> tooltipText) {
        this.tooltipTexts.clear();
        this.appendHoverTooltips(tooltipText);
        return this;
    }

    public Widget appendHoverTooltips(String ... tooltipText) {
        Arrays.stream(tooltipText).filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(Component::m_237115_).forEach(this.tooltipTexts::add);
        return this;
    }

    public Widget appendHoverTooltips(Component ... tooltipText) {
        Arrays.stream(tooltipText).filter(Objects::nonNull).forEach(this.tooltipTexts::add);
        return this;
    }

    public Widget appendHoverTooltips(List<Component> tooltipText) {
        this.tooltipTexts.addAll(tooltipText);
        return this;
    }

    public Widget kjs$setHoverTooltips(Component ... tooltipText) {
        this.tooltipTexts.clear();
        Arrays.stream(tooltipText).filter(Objects::nonNull).forEach(this.tooltipTexts::add);
        return this;
    }

    public Widget setBackground(IGuiTexture ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture.length > 1 ? new GuiTextureGroup(backgroundTexture) : backgroundTexture[0];
        return this;
    }

    public Widget setDrawBackgroundWhenHover(boolean drawBackgroundWhenHover) {
        this.drawBackgroundWhenHover = drawBackgroundWhenHover;
        return this;
    }

    public Widget setHoverTexture(IGuiTexture ... hoverTexture) {
        this.hoverTexture = hoverTexture.length > 1 ? new GuiTextureGroup(hoverTexture) : hoverTexture[0];
        return this;
    }

    public <T> Widget setDraggingProvider(Supplier<T> draggingProvider, BiFunction<T, Position, IGuiTexture> draggingRenderer) {
        this.draggingProvider = draggingProvider;
        this.draggingRenderer = draggingRenderer;
        return this;
    }

    public Widget setDraggingConsumer(Predicate<Object> draggingAccept, Consumer<Object> draggingIn, Consumer<Object> draggingOut, Consumer<Object> draggingSuccess) {
        this.draggingAccept = draggingAccept;
        this.draggingIn = draggingIn;
        this.draggingOut = draggingOut;
        this.draggingSuccess = draggingSuccess;
        return this;
    }

    public void animation(Animation animation) {
        if (this.isRemote()) {
            this.animation = animation;
            this.animation.setWidget(this);
        } else {
            Runnable runnable = animation.getOnFinish();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public boolean inAnimate() {
        return this.animation != null && !this.animation.isFinish();
    }

    public void setGui(ModularUI gui) {
        this.gui = gui;
    }

    public void setParentPosition(Position parentPosition) {
        this.parentPosition = parentPosition;
        this.recomputePosition();
    }

    @ConfigSetter(field="selfPosition")
    public void setSelfPosition(Position selfPosition) {
        if (this.selfPosition.equals(selfPosition)) {
            return;
        }
        this.selfPosition = selfPosition;
        this.recomputePosition();
        if (this.isParent(this.parent)) {
            this.parent.onChildSelfPositionUpdate(this);
        }
    }

    public final void setSelfPosition(int x, int y) {
        this.setSelfPosition(new Position(x, y));
    }

    public final void setSelfPositionX(int x) {
        this.setSelfPosition(x, this.getSelfPosition().y);
    }

    public final void setSelfPositionY(int y) {
        this.setSelfPosition(this.getSelfPosition().x, y);
    }

    public Position addSelfPosition(int addX, int addY) {
        this.setSelfPosition(new Position(this.selfPosition.x + addX, this.selfPosition.y + addY));
        return this.selfPosition;
    }

    public final int getSelfPositionX() {
        return this.getSelfPosition().x;
    }

    public final int getSelfPositionY() {
        return this.getSelfPosition().y;
    }

    @ConfigSetter(field="size")
    public void setSize(Size size) {
        if (this.size.equals(size)) {
            return;
        }
        this.size = size;
        this.onSizeUpdate();
        if (this.isParent(this.parent)) {
            this.parent.onChildSizeUpdate(this);
        }
    }

    public final void setSize(int width, int height) {
        this.setSize(new Size(width, height));
    }

    public final void setSizeWidth(int width) {
        this.setSize(width, this.getSize().height);
    }

    public final void setSizeHeight(int height) {
        this.setSize(this.getSize().width, height);
    }

    public final int getPositionX() {
        return this.getPosition().x;
    }

    public final int getPositionY() {
        return this.getPosition().y;
    }

    public final int getSizeWidth() {
        return this.getSize().width;
    }

    public final int getSizeHeight() {
        return this.getSize().height;
    }

    public final Rect getRect() {
        return Rect.of(this.position, this.size);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rect2i toRectangleBox() {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return new Rect2i(pos.x, pos.y, size.width, size.height);
    }

    protected void recomputePosition() {
        this.position = this.parentPosition.add(this.selfPosition);
        this.onPositionUpdate();
    }

    protected void onPositionUpdate() {
    }

    protected void onSizeUpdate() {
    }

    public boolean isMouseOverElement(double mouseX, double mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY);
    }

    @Nullable
    public Widget getHoverElement(double mouseX, double mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if (Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY)) {
            return this;
        }
        return null;
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseY >= (double)y && (double)(x + width) > mouseX && (double)(y + height) > mouseY;
    }

    public void initWidget() {
        this.initialized = true;
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
    }

    public void readInitialData(FriendlyByteBuf buffer) {
    }

    public void detectAndSendChanges() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        if (this.align != Align.NONE && this.isParent(this.parent)) {
            switch (this.align) {
                case TOP_LEFT: {
                    this.setSelfPosition(0, 0);
                    break;
                }
                case TOP_CENTER: {
                    this.setSelfPosition((this.parent.getSize().width - this.getSize().width) / 2, 0);
                    break;
                }
                case TOP_RIGHT: {
                    this.setSelfPosition(this.parent.getSize().width - this.getSize().width, 0);
                    break;
                }
                case LEFT_CENTER: {
                    this.setSelfPosition(0, (this.parent.getSize().height - this.getSize().height) / 2);
                    break;
                }
                case CENTER: {
                    this.setSelfPosition((this.parent.getSize().width - this.getSize().width) / 2, (this.parent.getSize().height - this.getSize().height) / 2);
                    break;
                }
                case RIGHT_CENTER: {
                    this.setSelfPosition(this.parent.getSize().width - this.getSize().width, (this.parent.getSize().height - this.getSize().height) / 2);
                    break;
                }
                case BOTTOM_LEFT: {
                    this.setSelfPosition(0, this.parent.getSize().height - this.getSize().height);
                    break;
                }
                case BOTTOM_CENTER: {
                    this.setSelfPosition((this.parent.getSize().width - this.getSize().width) / 2, this.parent.getSize().height - this.getSize().height);
                    break;
                }
                case BOTTOM_RIGHT: {
                    this.setSelfPosition(this.parent.getSize().width - this.getSize().width, this.parent.getSize().height - this.getSize().height);
                }
            }
        }
        if (this.backgroundTexture != null) {
            this.backgroundTexture.updateTick();
        }
        if (this.hoverTexture != null) {
            this.hoverTexture.updateTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawTooltipTexts(int mouseX, int mouseY) {
        if (this.tooltipTexts.size() > 0 && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this && this.gui != null && this.gui.getModularUIGui() != null) {
            this.gui.getModularUIGui().setHoverTooltip(this.tooltipTexts, ItemStack.f_41583_, null, null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawTooltipTexts(mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawBackgroundTexture(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        Size size;
        Position pos;
        boolean isHovered = this.isMouseOverElement(mouseX, mouseY);
        if (this.backgroundTexture != null && (!isHovered || this.drawBackgroundWhenHover)) {
            pos = this.getPosition();
            size = this.getSize();
            this.backgroundTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
        if (this.hoverTexture != null && isHovered && this.isActive()) {
            pos = this.getPosition();
            size = this.getSize();
            this.hoverTexture.draw(graphics, mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOverlay(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.overlay != null) {
            Position pos = this.getPosition();
            this.overlay.draw(graphics, mouseX, mouseY, pos.x, pos.y, this.size.width, this.size.height);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.draggingElement = null;
        this.tryToDrag = false;
        if (this.draggingProvider != null && this.isMouseOverElement(mouseX, mouseY)) {
            this.tryToDrag = true;
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Object element;
        if (!this.isMouseOverElement(mouseX, mouseY) && this.tryToDrag && this.draggingProvider != null && this.draggingRenderer != null && (element = this.draggingProvider.get()) != null) {
            this.getGui().getModularUIGui().setDraggingElement(element, this.draggingRenderer.apply(element, new Position((int)mouseX, (int)mouseY)));
        }
        if (this.isMouseOverElement(mouseX, mouseY) && this.draggingAccept.test(this.getGui().getModularUIGui().getDraggingElement())) {
            element = this.getGui().getModularUIGui().getDraggingElement();
            if (this.draggingElement != element && this.draggingIn != null) {
                this.draggingElement = element;
                this.draggingIn.accept(element);
            }
            return true;
        }
        if (this.draggingElement != null && this.draggingOut != null) {
            this.draggingOut.accept(this.draggingElement);
            this.draggingElement = null;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseMoved(double mouseX, double mouseY) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Object element;
        this.tryToDrag = false;
        if (this.isMouseOverElement(mouseX, mouseY) && this.getGui() != null && this.draggingAccept.test(this.getGui().getModularUIGui().getDraggingElement()) && this.draggingElement == (element = this.getGui().getModularUIGui().getDraggingElement()) && this.draggingSuccess != null) {
            this.draggingSuccess.accept(element);
            this.draggingElement = null;
            return true;
        }
        this.draggingElement = null;
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void setFocus(boolean focus) {
        if (this.gui != null) {
            ModularUIGuiContainer guiContainer = this.gui.getModularUIGui();
            Widget lastFocus = guiContainer.lastFocus;
            if (!focus) {
                this.isFocus = false;
                if (guiContainer.lastFocus == this) {
                    guiContainer.lastFocus = null;
                }
                this.onFocusChanged(lastFocus, guiContainer.lastFocus);
            } else if (guiContainer.switchFocus(this)) {
                this.isFocus = true;
                this.onFocusChanged(lastFocus, guiContainer.lastFocus);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onFocusChanged(@Nullable Widget lastFocus, Widget focus) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
    }

    protected final void writeUpdateInfo(int id, Consumer<FriendlyByteBuf> FriendlyByteBufWriter) {
        if (this.uiAccess != null && this.gui != null) {
            this.uiAccess.writeUpdateInfo(this, id, FriendlyByteBufWriter);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected final void writeClientAction(int id, Consumer<FriendlyByteBuf> FriendlyByteBufWriter) {
        if (this.uiAccess != null && !this.isClientSideWidget) {
            this.uiAccess.writeClientAction(this, id, FriendlyByteBufWriter);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playButtonClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isShiftDown() {
        long id = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)id, (int)340) || InputConstants.m_84830_((long)id, (int)340);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isCtrlDown() {
        return Screen.m_96637_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isAltDown() {
        long id = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)id, (int)342) || InputConstants.m_84830_((long)id, (int)346);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isKeyDown(int keyCode) {
        long id = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)id, (int)keyCode);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isMouseDown(int button) {
        return this.gui != null && this.gui.getModularUIGui().isButtonPressed(button);
    }

    public boolean isRemote() {
        return this.gui != null && this.gui.holder != null ? this.gui.holder.isRemote() : LDLib.isRemote();
    }

    protected void setParent(WidgetGroup parent) {
        this.parent = parent;
    }

    public boolean isParent(WidgetGroup widgetGroup) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == widgetGroup) {
            return true;
        }
        return this.parent.isParent(widgetGroup);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreenSizeUpdate(int screenWidth, int screenHeight) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Rect2i> getGuiExtraAreas(Rect2i guiRect, List<Rect2i> list) {
        Rect2i rect2i = this.toRectangleBox();
        if (rect2i.m_110085_() < guiRect.m_110085_() || rect2i.m_110085_() + rect2i.m_110090_() > guiRect.m_110085_() + guiRect.m_110090_() || rect2i.m_110086_() < guiRect.m_110086_() || rect2i.m_110086_() + rect2i.m_110091_() > guiRect.m_110086_() + guiRect.m_110091_()) {
            list.add(this.toRectangleBox());
        }
        return list;
    }

    public ModularUI getGui() {
        return this.gui;
    }

    public Widget setUiAccess(WidgetUIAccess uiAccess) {
        this.uiAccess = uiAccess;
        return this;
    }

    public Widget setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Position getParentPosition() {
        return this.parentPosition;
    }

    public Position getSelfPosition() {
        return this.selfPosition;
    }

    public Position getPosition() {
        return this.position;
    }

    public Size getSize() {
        return this.size;
    }

    public Align getAlign() {
        return this.align;
    }

    public Widget setAlign(Align align) {
        this.align = align;
        return this;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public Widget setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Widget setActive(boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    public boolean isClientSideWidget() {
        return this.isClientSideWidget;
    }

    public List<Component> getTooltipTexts() {
        return this.tooltipTexts;
    }

    public IGuiTexture getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public IGuiTexture getOverlay() {
        return this.overlay;
    }

    public Widget setOverlay(IGuiTexture overlay) {
        this.overlay = overlay;
        return this;
    }

    public WidgetGroup getParent() {
        return this.parent;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

