/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.mojang.datafixers.util.Either;
import java.io.File;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UIResourceTexture
implements IGuiTexture {
    private static Resource<IGuiTexture> projectResource;
    private static boolean isProject;
    private Resource<IGuiTexture> resource;
    public final Either<String, File> key;

    public static void setCurrentResource(Resource<IGuiTexture> resource, boolean isProject) {
        projectResource = resource;
        UIResourceTexture.isProject = isProject;
    }

    public static void clearCurrentResource() {
        projectResource = null;
        isProject = false;
    }

    public UIResourceTexture(Either<String, File> key) {
        this.key = key;
    }

    public UIResourceTexture(Resource<IGuiTexture> resource, Either<String, File> key) {
        this.resource = resource;
        this.key = key;
    }

    public IGuiTexture getTexture() {
        return this.resource == null ? IGuiTexture.MISSING_TEXTURE : this.resource.getResourceOrDefault(this.key, IGuiTexture.MISSING_TEXTURE);
    }

    @Override
    public IGuiTexture setColor(int color) {
        return this.getTexture().setColor(color);
    }

    @Override
    public IGuiTexture rotate(float degree) {
        return this.getTexture().rotate(degree);
    }

    @Override
    public IGuiTexture scale(float scale) {
        return this.getTexture().scale(scale);
    }

    @Override
    public IGuiTexture transform(int xOffset, int yOffset) {
        return this.getTexture().transform(xOffset, yOffset);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        this.getTexture().draw(graphics, mouseX, mouseY, x, y, width, height);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateTick() {
        this.getTexture().updateTick();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawSubArea(GuiGraphics graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        this.getTexture().drawSubArea(graphics, x, y, width, height, drawnU, drawnV, drawnWidth, drawnHeight);
    }

    @Override
    public void createPreview(ConfiguratorGroup father) {
        this.getTexture().createPreview(father);
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        this.getTexture().buildConfigurator(father);
    }

    @Override
    public void setUIResource(Resource<IGuiTexture> texturesResource) {
        this.setResource(texturesResource);
    }

    public static Resource<IGuiTexture> getProjectResource() {
        return projectResource;
    }

    public static boolean isProject() {
        return isProject;
    }

    public void setResource(Resource<IGuiTexture> resource) {
        this.resource = resource;
    }
}

