/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Supplier;

public class DraggablePanelWidget
extends WidgetGroup {
    protected WidgetGroup title;
    protected WidgetGroup content;
    protected Supplier<String> titleSupplier;
    protected boolean isDraggable = true;
    protected boolean isPressed = false;
    protected long lastClickTick;
    protected double lastMouseX;
    protected double lastMouseY;
    protected Position lastPosition;

    public DraggablePanelWidget(String title, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setBackground(ColorPattern.WHITE.borderTexture(1).setTopRadius(5.0f));
        this.titleSupplier = () -> title;
    }

    public void updateSize(Size size) {
        super.setSize(size);
        this.loadWidgets();
    }

    @Override
    public void initWidget() {
        super.initWidget();
        this.loadWidgets();
    }

    protected void loadWidgets() {
        this.clearAllWidgets();
        this.title = new WidgetGroup(0, 0, this.getSizeWidth(), 15);
        this.addWidget(this.title);
        this.title.setBackground(ColorPattern.BLACK.rectTexture().setTopRadius(5.0f));
        this.content = new WidgetGroup(0, 15, this.getSizeWidth(), this.getSizeHeight() - 15);
        this.addWidget(this.content);
        this.content.setBackground(ColorPattern.DARK_GRAY.rectTexture());
        this.title.clearAllWidgets();
        this.title.setSize(this.getSizeWidth(), 15);
        this.title.addWidget(new ImageWidget(0, 14, this.getSizeWidth(), 1, ColorPattern.WHITE.rectTexture()));
        this.title.addWidget(new ImageWidget(5, 2, this.getSizeWidth() - 10, 11, new TextTexture().setSupplier(this.titleSupplier).setWidth(this.getSizeWidth() - 10).setType(TextTexture.TextType.LEFT)));
    }

    public boolean isCollapsed() {
        return !this.content.isVisible();
    }

    public void setCollapsed(boolean collapsed) {
        this.content.setVisible(!collapsed);
        this.setSize(this.getSizeWidth(), collapsed ? 15 : this.content.getSizeHeight() + 15);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (button == 0 && this.title.isMouseOverElement(mouseX, mouseY)) {
            if (this.lastClickTick != 0L && this.gui.getTickCount() - this.lastClickTick < 10L) {
                this.setCollapsed(!this.isCollapsed());
                return true;
            }
            this.lastClickTick = this.gui.getTickCount();
            if (super.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            this.isPressed = true;
            this.lastPosition = this.getSelfPosition();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isPressed && this.isDraggable) {
            this.setSelfPosition(this.lastPosition.add((int)(mouseX - this.lastMouseX), (int)(mouseY - this.lastMouseY)));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isPressed = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public WidgetGroup getTitle() {
        return this.title;
    }

    public WidgetGroup getContent() {
        return this.content;
    }

    public void setTitleSupplier(Supplier<String> titleSupplier) {
        this.titleSupplier = titleSupplier;
    }

    public Supplier<String> getTitleSupplier() {
        return this.titleSupplier;
    }

    public void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }
}

