/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.DraggablePanelWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.GraphViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.DynamicTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import net.minecraft.client.Minecraft;

public class DebugPanelWidget
extends DraggablePanelWidget {
    private final GraphViewWidget graphView;

    public DebugPanelWidget(GraphViewWidget graphView) {
        super("Debug", 0, 0, 120, 75);
        this.graphView = graphView;
    }

    @Override
    protected void loadWidgets() {
        super.loadWidgets();
        this.content.addWidget(new ImageWidget(5, 2, 110, 10, new TextTexture().setSupplier(() -> LocalizationUtils.format("graph_processor.depth", this.graphView.getGraph().getDepth())).setWidth(110).setType(TextTexture.TextType.LEFT)));
        int width = Minecraft.m_91087_().f_91062_.m_92895_(LocalizationUtils.format("graph_processor.show_debug_info", new Object[0]));
        this.content.addWidget(new ImageWidget(5, 15, width, 15, new TextTexture("graph_processor.show_debug_info")));
        this.content.addWidget(new SwitchWidget(width + 8, 17, 10, 10, (cd, pressed) -> this.graphView.setShowDebugInfo((boolean)pressed)).setPressed(this.graphView.isShowDebugInfo()).setTexture(new ColorBorderTexture(-1, -1).setRadius(5.0f), new GuiTextureGroup(new ColorBorderTexture(-1, -1).setRadius(5.0f), new ColorRectTexture(-1).setRadius(5.0f).scale(0.5f))));
        this.content.addWidget(new ButtonWidget(5, 32, 110, 10, cd -> this.graphView.runAll()).setButtonTexture(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new GuiTextureGroup(new TextTexture("graph_processor.process_mode.run_all"), new DynamicTexture(() -> !this.graphView.isRunStep() ? ColorPattern.YELLOW.borderTexture(1).setRadius(5.0f) : IGuiTexture.EMPTY))));
        this.content.addWidget(new ButtonWidget(5, 47, 110, 10, cd -> this.graphView.runStep()).setButtonTexture(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new GuiTextureGroup(new TextTexture(() -> this.graphView.isRunStepFinish() ? "graph_processor.process_mode.step_finish" : "graph_processor.process_mode.step"), new DynamicTexture(() -> this.graphView.isRunStep() ? ColorPattern.rainbowRectTexture(1).setRadius(5.0f) : IGuiTexture.EMPTY))));
    }

    public GraphViewWidget getGraphView() {
        return this.graphView;
    }
}

