/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.resource;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.TriFunction;

public class ResourceContainer<T, C extends Widget>
extends WidgetGroup {
    protected final ResourcePanel panel;
    protected final Resource<T> resource;
    protected final Map<Either<String, File>, C> widgets;
    protected DraggableScrollableWidgetGroup container;
    protected Function<Either<String, File>, C> widgetSupplier;
    protected Function<String, T> onAdd;
    protected Predicate<Either<String, File>> canRemove;
    protected Consumer<Either<String, File>> onRemove;
    protected Predicate<Either<String, File>> canGlobalChange;
    protected Consumer<Either<String, File>> onGlobalChange;
    protected Predicate<Either<String, File>> canEdit;
    protected Consumer<Either<String, File>> onEdit;
    protected BiConsumer<Either<String, File>, TreeBuilder.Menu> onMenu;
    protected Function<Either<String, File>, Object> draggingMapping;
    protected TriFunction<Either<String, File>, Object, Position, IGuiTexture> draggingRenderer;
    protected Supplier<String> nameSupplier;
    protected Predicate<String> renamePredicate;
    @Nullable
    protected Either<String, File> selected;
    private boolean firstClick;
    private Either<String, File> firstClickName;
    private long firstClickTime;

    public ResourceContainer(Resource<T> resource, ResourcePanel panel) {
        super(3, 0, panel.getSize().width - 6, panel.getSize().height - 14);
        this.setClientSideWidget();
        this.widgets = new HashMap<Either<String, File>, C>();
        this.panel = panel;
        this.resource = resource;
    }

    public <D> ResourceContainer<T, C> setDragging(Function<Either<String, File>, D> draggingMapping, Function<D, IGuiTexture> draggingRenderer) {
        this.draggingMapping = draggingMapping::apply;
        this.draggingRenderer = (k, o, p) -> (IGuiTexture)draggingRenderer.apply(o);
        return this;
    }

    public <D> ResourceContainer<T, C> setDragging(Function<Either<String, File>, D> draggingMapping, TriFunction<Either<String, File>, D, Position, IGuiTexture> draggingRenderer) {
        this.draggingMapping = draggingMapping::apply;
        this.draggingRenderer = (k, o, p) -> (IGuiTexture)draggingRenderer.apply(k, o, p);
        return this;
    }

    @Override
    public void initWidget() {
        Size size = this.getSize();
        this.container = new DraggableScrollableWidgetGroup(1, 2, size.width - 2, size.height - 2);
        this.container.setYScrollBarWidth(4).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(2.0f));
        this.addWidget(this.container);
        this.reBuild();
        super.initWidget();
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.gui.getTickCount() % 20L == 0L) {
            if (this.selected != null && this.selected.right().isPresent()) {
                T selectedResource = this.resource.getResource(this.selected);
                Tag resTag = this.resource.serialize(selectedResource);
                EndTag fileTag = EndTag.f_128534_;
                try {
                    CompoundTag fileData = NbtIo.m_128953_((File)((File)this.selected.right().get()));
                    if (fileData != null && fileData.m_128461_("type").equals(this.resource.name()) && fileData.m_128441_("data")) {
                        fileTag = fileData.m_128423_("data");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!fileTag.equals(resTag)) {
                    this.resource.addStaticResource((File)this.selected.right().get(), selectedResource);
                }
            }
            if (this.resource.loadAndUpdateStaticResource()) {
                this.reBuild();
            }
        }
    }

    public void reBuild() {
        this.selected = null;
        this.container.clearAllWidgets();
        int width = this.getSize().getWidth();
        int x = 1;
        int y = 3;
        for (Map.Entry<Either<String, File>, T> entry : this.resource.allResources().toList()) {
            Widget widget = (Widget)this.widgetSupplier.apply(entry.getKey());
            Either<String, File> key = entry.getKey();
            this.widgets.put(key, widget);
            Size size = widget.getSize();
            SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, 0, size.width, size.height + 14);
            selectableWidgetGroup.setDraggingProvider(this.draggingMapping == null ? entry::getValue : () -> this.draggingMapping.apply(key), (c, p) -> this.draggingRenderer == null ? new TextTexture(this.resource.getResourceName(key)) : (IGuiTexture)this.draggingRenderer.apply((Object)key, c, p));
            selectableWidgetGroup.addWidget(widget);
            if (this.resource.supportStaticResource() && (this.canGlobalChange == null || this.canGlobalChange.test(key))) {
                selectableWidgetGroup.addWidget(new ImageWidget(1, 1, 10, 10, (IGuiTexture)key.map(l -> Icons.LOCAL, r -> Icons.GLOBAL.copy().setDynamicColor(ColorPattern::generateRainbowColor))).setHoverTooltips(key.left().isPresent() ? "ldlib.gui.editor.menu.resource.builtin" : "ldlib.gui.editor.menu.resource.static"));
            }
            selectableWidgetGroup.addWidget(new ImageWidget(0, size.height + 3, size.width, 10, new TextTexture(this.resource.getResourceName(key)).setWidth(size.width).setType(TextTexture.TextType.ROLL)));
            selectableWidgetGroup.setOnSelected(s -> {
                this.selected = key;
            });
            selectableWidgetGroup.setOnUnSelected(s -> {
                this.selected = null;
            });
            selectableWidgetGroup.setSelectedTexture(ColorPattern.T_GRAY.rectTexture());
            size = selectableWidgetGroup.getSize();
            if (size.width >= width - 5) {
                selectableWidgetGroup.setSelfPosition(new Position(0, y));
                y += size.height + 3;
            } else if (size.width < width - 5 - x) {
                selectableWidgetGroup.setSelfPosition(new Position(x, y));
                x += size.width + 3;
            } else {
                x = 1;
                selectableWidgetGroup.setSelfPosition(new Position(x, y += size.height + 3));
                x += size.width + 3;
            }
            this.container.addWidget(selectableWidgetGroup);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (button == 1 && this.isMouseOverElement(mouseX, mouseY)) {
            this.panel.getEditor().openMenu(mouseX, mouseY, this.getMenu());
            return true;
        }
        if (button == 0 && this.isMouseOverElement(mouseX, mouseY) && this.selected != null && this.onEdit != null && (this.canEdit == null || this.canEdit.test(this.selected))) {
            if (this.firstClick && this.firstClickName.equals(this.selected) && this.gui.getTickCount() - this.firstClickTime < 10L) {
                this.editResource();
                this.firstClick = false;
                return true;
            }
            this.firstClick = true;
            this.firstClickName = this.selected;
            this.firstClickTime = this.gui.getTickCount();
        }
        return result;
    }

    protected TreeBuilder.Menu getMenu() {
        TreeBuilder.Menu menu = TreeBuilder.Menu.start();
        if (this.selected != null && this.onEdit != null && this.canEdit != null && this.canEdit.test(this.selected)) {
            menu.leaf(Icons.EDIT_FILE, "ldlib.gui.editor.menu.edit", this::editResource);
        }
        menu.leaf("ldlib.gui.editor.menu.rename", this::renameResource);
        menu.crossLine();
        if (this.resource.supportStaticResource()) {
            menu.leaf(Icons.FOLDER, "ldlib.gui.editor.menu.static_resource.folder", () -> Util.m_137581_().m_137644_(this.resource.getStaticLocation()));
            if (this.selected != null && (this.canGlobalChange == null || this.canGlobalChange.test(this.selected))) {
                if (this.selected.left().isPresent()) {
                    menu.leaf(Icons.GLOBAL, "ldlib.gui.editor.menu.resource.builtin_to_static", () -> {
                        Either<String, File> preName = this.selected;
                        String name = this.resource.getResourceName(this.selected);
                        T value = this.resource.getResource(this.selected);
                        if (value != null) {
                            this.resource.removeResource(this.selected);
                            this.resource.addStaticResource(this.resource.getStaticResourceFile(name), value);
                            this.reBuild();
                        }
                        if (this.onGlobalChange != null) {
                            this.onGlobalChange.accept(preName);
                        }
                    });
                } else {
                    menu.leaf(Icons.LOCAL, "ldlib.gui.editor.menu.resource.static_to_builtin", () -> {
                        Either<String, File> preName = this.selected;
                        String name = this.resource.getResourceName(this.selected);
                        T value = this.resource.getResource(this.selected);
                        if (value != null) {
                            this.resource.removeResource(this.selected);
                            this.resource.addBuiltinResource(name, value);
                            this.reBuild();
                        }
                        if (this.onGlobalChange != null) {
                            this.onGlobalChange.accept(preName);
                        }
                    });
                }
            }
            menu.crossLine();
        }
        menu.leaf(Icons.COPY, "ldlib.gui.editor.menu.copy", this::copy);
        menu.leaf(Icons.PASTE, "ldlib.gui.editor.menu.paste", this::paste);
        if (this.onAdd != null) {
            menu.leaf(Icons.ADD_FILE, "ldlib.gui.editor.menu.add_resource", this::addNewResource);
        }
        menu.leaf(Icons.REMOVE_FILE, "ldlib.gui.editor.menu.remove", this::removeSelectedResource);
        if (this.onMenu != null) {
            this.onMenu.accept(this.selected, menu);
        }
        return menu;
    }

    protected void paste() {
        this.panel.getEditor().ifCopiedPresent(this.resource.name(), c -> {
            T value = this.getResource().deserialize((Tag)c);
            this.resource.addBuiltinResource(this.genNewFileName(), value);
            this.reBuild();
        });
    }

    protected void copy() {
        if (this.selected != null) {
            this.panel.getEditor().setCopy(this.resource.name(), this.resource.serialize(this.resource.getResource(this.selected)));
        }
    }

    protected void renameResource() {
        if (this.selected != null) {
            DialogWidget.showStringEditorDialog(Editor.INSTANCE, LocalizationUtils.format("ldlib.gui.editor.tips.rename", new Object[0]) + " " + LocalizationUtils.format(this.resource.name(), new Object[0]), this.resource.getResourceName(this.selected), s -> {
                if (((Boolean)this.selected.map(l -> this.resource.hasBuiltinResource((String)s), r -> this.resource.hasStaticResource(this.resource.getStaticResourceFile((String)s)))).booleanValue()) {
                    return false;
                }
                if (this.renamePredicate != null) {
                    return this.renamePredicate.test((String)s);
                }
                return true;
            }, s -> {
                if (s == null) {
                    return;
                }
                T stored = this.resource.removeResource(this.selected);
                if (stored != null) {
                    Either name = this.selected.mapBoth(l -> s, r -> this.resource.getStaticResourceFile((String)s));
                    this.resource.addResource((Either<String, File>)name, stored);
                }
                this.reBuild();
            });
        }
    }

    protected void editResource() {
        if (this.onEdit != null && this.selected != null && (this.canEdit == null || this.canEdit.test(this.selected))) {
            this.onEdit.accept(this.selected);
        }
    }

    protected String genNewFileName() {
        Object randomName = "new ";
        if (this.nameSupplier != null) {
            randomName = this.nameSupplier.get();
        } else {
            int i = 0;
            while (this.resource.hasBuiltinResource((String)randomName + i)) {
                ++i;
            }
            randomName = (String)randomName + i;
        }
        return randomName;
    }

    protected void addNewResource() {
        if (this.onAdd != null) {
            String randomName = this.genNewFileName();
            this.resource.addBuiltinResource(randomName, this.onAdd.apply(randomName));
            this.reBuild();
        }
    }

    protected void removeSelectedResource() {
        if (this.selected == null) {
            return;
        }
        if (this.canRemove == null || this.canRemove.test(this.selected)) {
            if (this.onRemove != null) {
                this.onRemove.accept(this.selected);
            }
            this.resource.removeResource(this.selected);
            this.reBuild();
        }
    }

    public ResourcePanel getPanel() {
        return this.panel;
    }

    public Resource<T> getResource() {
        return this.resource;
    }

    public Map<Either<String, File>, C> getWidgets() {
        return this.widgets;
    }

    public ResourceContainer<T, C> setWidgetSupplier(Function<Either<String, File>, C> widgetSupplier) {
        this.widgetSupplier = widgetSupplier;
        return this;
    }

    public Function<Either<String, File>, C> getWidgetSupplier() {
        return this.widgetSupplier;
    }

    public ResourceContainer<T, C> setOnAdd(Function<String, T> onAdd) {
        this.onAdd = onAdd;
        return this;
    }

    public ResourceContainer<T, C> setCanRemove(Predicate<Either<String, File>> canRemove) {
        this.canRemove = canRemove;
        return this;
    }

    public ResourceContainer<T, C> setOnRemove(Consumer<Either<String, File>> onRemove) {
        this.onRemove = onRemove;
        return this;
    }

    public ResourceContainer<T, C> setCanGlobalChange(Predicate<Either<String, File>> canGlobalChange) {
        this.canGlobalChange = canGlobalChange;
        return this;
    }

    public ResourceContainer<T, C> setOnGlobalChange(Consumer<Either<String, File>> onGlobalChange) {
        this.onGlobalChange = onGlobalChange;
        return this;
    }

    public ResourceContainer<T, C> setCanEdit(Predicate<Either<String, File>> canEdit) {
        this.canEdit = canEdit;
        return this;
    }

    public ResourceContainer<T, C> setOnEdit(Consumer<Either<String, File>> onEdit) {
        this.onEdit = onEdit;
        return this;
    }

    public ResourceContainer<T, C> setOnMenu(BiConsumer<Either<String, File>, TreeBuilder.Menu> onMenu) {
        this.onMenu = onMenu;
        return this;
    }

    public ResourceContainer<T, C> setNameSupplier(Supplier<String> nameSupplier) {
        this.nameSupplier = nameSupplier;
        return this;
    }

    public ResourceContainer<T, C> setRenamePredicate(Predicate<String> renamePredicate) {
        this.renamePredicate = renamePredicate;
        return this;
    }

    @Nullable
    public Either<String, File> getSelected() {
        return this.selected;
    }
}

