/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.resource;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntriesResourceContainer
extends ResourceContainer<String, TextFieldWidget> {
    public EntriesResourceContainer(Resource<String> resource, ResourcePanel panel) {
        super(resource, panel);
        this.setDragging((Either<String, File> key) -> key.left().orElse(""), (D key) -> new TextTexture((String)resource.getBuiltinResource((String)key)));
        this.setOnAdd(key -> "Hello KilaBash!");
        this.setNameSupplier(() -> {
            Object randomName = "new.";
            int i = 0;
            while (this.getResource().hasBuiltinResource((String)randomName + i)) {
                ++i;
            }
            randomName = (String)randomName + i;
            return randomName;
        });
    }

    @Override
    public void reBuild() {
        this.selected = null;
        this.container.clearAllWidgets();
        int width = (this.getSize().getWidth() - 16) / 2;
        int i = 0;
        for (Map.Entry entry : this.resource.allResources().toList()) {
            TextFieldWidget widget = new TextFieldWidget(width, 0, width, 15, null, s -> this.resource.addResource((Either<String, File>)((Either)entry.getKey()), s));
            widget.setCurrentString(entry.getValue());
            widget.setBordered(false);
            widget.setBackground((IGuiTexture)ColorPattern.T_WHITE.rectTexture());
            this.widgets.put(entry.getKey(), widget);
            Size size = widget.getSize();
            SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(3, 3 + i * 17, width * 2, 15){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    this.draggingElement = null;
                    this.tryToDrag = this.draggingProvider != null && this.isMouseOverElement(mouseX, mouseY);
                    return super.mouseClicked(mouseX, mouseY, button);
                }
            };
            selectableWidgetGroup.setDraggingProvider(this.draggingMapping == null ? entry::getValue : () -> this.draggingMapping.apply((Either)entry.getKey()), (c, p) -> (IGuiTexture)this.draggingRenderer.apply((Object)((Either)entry.getKey()), c, p));
            selectableWidgetGroup.addWidget(new ImageWidget(0, 0, width, 15, new GuiTextureGroup(ColorPattern.GRAY.rectTexture(), new TextTexture(this.resource.getResourceName(entry.getKey()) + " ").setWidth(size.width).setType(TextTexture.TextType.ROLL))));
            selectableWidgetGroup.addWidget(widget);
            selectableWidgetGroup.setOnSelected(s -> {
                this.selected = (Either)entry.getKey();
            });
            selectableWidgetGroup.setOnUnSelected(s -> {
                this.selected = null;
            });
            selectableWidgetGroup.setSelectedTexture(ColorPattern.T_GRAY.rectTexture());
            this.container.addWidget(selectableWidgetGroup);
            ++i;
        }
    }
}

