/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.runtime;

import com.lowdragmc.lowdraglib.gui.editor.accessors.IConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorAccessors;
import com.lowdragmc.lowdraglib.utils.ReflectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ConfiguratorParser {
    public static void createConfigurators(ConfiguratorGroup father, Map<String, Method> setters, Class<?> clazz, Object object) {
        if (clazz == Object.class || clazz == null) {
            return;
        }
        for (Method method : clazz.getMethods()) {
            ConfigSetter configSetter;
            String name;
            if (!method.isAnnotationPresent(ConfigSetter.class) || setters.containsKey(name = (configSetter = method.getAnnotation(ConfigSetter.class)).field())) continue;
            setters.put(name, method);
        }
        ConfiguratorParser.createConfigurators(father, setters, clazz.getSuperclass(), object);
        if (clazz.isAnnotationPresent(Configurable.class)) {
            Configurable configurable = clazz.getAnnotation(Configurable.class);
            String name = configurable.showName() ? (configurable.name().isEmpty() ? clazz.getSimpleName() : configurable.name()) : "";
            ConfiguratorGroup newGroup = new ConfiguratorGroup(name, configurable.collapse());
            newGroup.setCanCollapse(configurable.canCollapse());
            newGroup.setTips(configurable.tips());
            father.addConfigurators(newGroup);
            father = newGroup;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            ConfiguratorParser.createFieldConfigurator((Field)accessibleObject, father, clazz, setters, object);
        }
    }

    public static void createFieldConfigurator(Field field, ConfiguratorGroup father, Class<?> clazz, Map<String, Method> setters, Object object) {
        if (Modifier.isStatic(field.getModifiers())) {
            return;
        }
        if (field.isAnnotationPresent(Configurable.class)) {
            Configurable configurable = field.getAnnotation(Configurable.class);
            if (configurable.subConfigurable()) {
                Class<?> rawClass = ReflectionUtils.getRawType(field.getGenericType());
                try {
                    field.setAccessible(true);
                    Object value2 = field.get(object);
                    if (value2 != null) {
                        String name = configurable.showName() ? (configurable.name().isEmpty() ? field.getName() : configurable.name()) : "";
                        ConfiguratorGroup newGroup = new ConfiguratorGroup(name, configurable.collapse());
                        newGroup.setCanCollapse(configurable.canCollapse());
                        newGroup.setTips(configurable.tips());
                        if (value2 instanceof IConfigurable) {
                            IConfigurable subConfigurable = (IConfigurable)value2;
                            subConfigurable.buildConfigurator(newGroup);
                        } else {
                            ConfiguratorParser.createConfigurators(newGroup, new HashMap<String, Method>(), rawClass, value2);
                        }
                        father.addConfigurators(newGroup);
                    }
                }
                catch (IllegalAccessException value2) {}
            } else {
                IConfiguratorAccessor<?> accessor = ConfiguratorAccessors.findByType(field.getGenericType());
                field.setAccessible(true);
                String name = configurable.showName() ? (configurable.name().isEmpty() ? field.getName() : configurable.name()) : "";
                Method setter = setters.get(field.getName());
                Configurator configurator = accessor.create(name, () -> {
                    try {
                        return field.get(object);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }, value -> {
                    try {
                        if (setter == null) {
                            field.set(object, value);
                        } else {
                            setter.invoke(object, value);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, configurable.forceUpdate(), field);
                configurator.setTips(configurable.tips());
                father.addConfigurators(configurator);
            }
        }
    }
}

