/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer.impl;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.FacadeBlockWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockStateRenderer
implements ISerializableRenderer {
    protected BlockInfo blockInfo;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel itemModel;

    protected BlockStateRenderer() {
        this.blockInfo = null;
    }

    public BlockStateRenderer(BlockState state) {
        this(BlockInfo.fromBlockState(state == null ? Blocks.f_50375_.m_49966_() : state));
    }

    public BlockStateRenderer(BlockInfo blockInfo) {
        BlockInfo blockInfo2 = this.blockInfo = blockInfo == null ? new BlockInfo(Blocks.f_50375_) : blockInfo;
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public BlockState getState(@Nullable BlockState blockState) {
        BlockState state = this.getBlockInfo().getBlockState();
        if (blockState == null) {
            return state;
        }
        Direction facing = Direction.NORTH;
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        } else if (blockState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        try {
            switch (facing) {
                case EAST: {
                    state = state.m_60717_(Rotation.CLOCKWISE_90);
                    break;
                }
                case WEST: {
                    state = state.m_60717_(Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
                case SOUTH: {
                    state = state.m_60717_(Rotation.CLOCKWISE_180);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected BakedModel getItemModel(ItemStack renderItem) {
        if (this.itemModel == null) {
            this.itemModel = Minecraft.m_91087_().m_91291_().m_174264_(renderItem, null, null, 0);
        }
        return this.itemModel;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        ItemStack renderItem = this.getBlockInfo().getItemStackForm();
        BakedModel model = this.getItemModel(renderItem);
        if (model == null) {
            return ISerializableRenderer.super.getParticleTexture();
        }
        return model.m_6160_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack renderItem = this.getBlockInfo().getItemStackForm();
        itemRenderer.m_115143_(renderItem, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, this.getItemModel(renderItem));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        ItemStack renderItem = this.getBlockInfo().getItemStackForm();
        BakedModel model = this.getItemModel(renderItem);
        if (model != null) {
            return model.m_7547_();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        if ((state = this.getState(state)).m_60799_() != RenderShape.INVISIBLE) {
            BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
            BakedModel model = brd.m_110910_(state);
            return model.m_213637_(state, side, rand);
        }
        return Collections.emptyList();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BlockEntity getBlockEntity(BlockAndTintGetter world, BlockPos pos) {
        BlockInfo blockInfo = this.getBlockInfo();
        BlockEntity tile = blockInfo.getBlockEntity(pos);
        if (tile != null && world instanceof Level) {
            try {
                BlockState state = this.getState(world.m_8055_(pos));
                tile.m_155250_(state);
                tile.m_142339_((Level)new FacadeBlockWorld((Level)world, pos, state, tile));
            }
            catch (Throwable throwable) {
                blockInfo.setHasBlockEntity(false);
            }
        }
        return tile;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity tileEntity) {
        if (!this.getBlockInfo().getBlockState().m_60819_().m_76178_()) {
            return true;
        }
        if ((tileEntity = this.getBlockEntity((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_())) == null) {
            return false;
        }
        return Minecraft.m_91087_().m_167982_().m_112265_(tileEntity) != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity tileEntity) {
        if ((tileEntity = this.getBlockEntity((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_())) == null) {
            return false;
        }
        BlockEntityRenderer tesr = Minecraft.m_91087_().m_167982_().m_112265_(tileEntity);
        if (tesr != null) {
            return tesr.m_5932_(tileEntity);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity tileEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockInfo block = this.getBlockInfo();
        FluidState fluidState = block.getBlockState().m_60819_();
        if (!fluidState.m_76178_()) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
            Minecraft.m_91087_().m_91289_().m_234363_(tileEntity.m_58899_(), (BlockAndTintGetter)tileEntity.m_58904_(), builder, block.getBlockState(), fluidState);
        }
        if ((tileEntity = this.getBlockEntity((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_())) == null) {
            return;
        }
        BlockEntityRenderer tesr = Minecraft.m_91087_().m_167982_().m_112265_(tileEntity);
        if (tesr != null) {
            try {
                tesr.m_6922_(tileEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
            }
            catch (Exception e) {
                this.getBlockInfo().setHasBlockEntity(false);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            this.itemModel = null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useAO() {
        BlockState state = this.getBlockInfo().getBlockState();
        if (state.m_60799_() != RenderShape.INVISIBLE) {
            return Minecraft.m_91087_().m_91289_().m_110910_(state).m_7541_();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isGui3d() {
        BakedModel model = this.getItemModel(this.getBlockInfo().getItemStackForm());
        if (model == null) {
            return ISerializableRenderer.super.isGui3d();
        }
        return model.m_7539_();
    }

    public BlockInfo getBlockInfo() {
        return this.blockInfo;
    }
}

