/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.syncdata;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.CustomObjectAccessor;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ChemicalStackAccessor
extends CustomObjectAccessor<ChemicalStack> {
    public ChemicalStackAccessor() {
        super(ChemicalStack.class, true);
    }

    public ITypedPayload<?> serialize(AccessorOp op, ChemicalStack value) {
        CompoundTag tag = new CompoundTag();
        ChemicalType.getTypeFor((Chemical)value.getType()).write(tag);
        value.write(tag);
        return NbtTagPayload.of((Tag)tag);
    }

    public ChemicalStack<?> deserialize(AccessorOp op, ITypedPayload payload) {
        NbtTagPayload nbtPayload;
        Object object;
        if (payload instanceof NbtTagPayload && (object = (nbtPayload = (NbtTagPayload)payload).getPayload()) instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)object;
            ChemicalType type = ChemicalType.fromNBT((CompoundTag)tag);
            if (type == ChemicalType.GAS) {
                return GasStack.readFromNBT((CompoundTag)tag);
            }
            if (type == ChemicalType.INFUSION) {
                return InfusionStack.readFromNBT((CompoundTag)tag);
            }
            if (type == ChemicalType.PIGMENT) {
                return PigmentStack.readFromNBT((CompoundTag)tag);
            }
            if (type == ChemicalType.SLURRY) {
                return SlurryStack.readFromNBT((CompoundTag)tag);
            }
        }
        return null;
    }
}

