/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.IUIProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat.PNCHeatExchangerTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

@LDLRegister(name="pneumatic_heat_exchanger", group="trait", modID="pneumaticcraft")
public class PNCHeatExchangerTraitDefinition
extends RecipeCapabilityTraitDefinition
implements IUIProviderTrait {
    @Configurable(name="config.definition.trait.pneumatic_heat_exchanger.thermal_capacity", tips={"config.definition.trait.pneumatic_heat_exchanger.thermal_capacity.tips.0", "config.definition.trait.pneumatic_heat_exchanger.thermal_capacity.tips.1"})
    @NumberRange(range={0.0, 1.7976931348623157E308})
    private float thermalCapacity = 1.0f;
    @Configurable(name="config.definition.trait.pneumatic_heat_exchanger.thermal_resistance", tips={"config.definition.trait.pneumatic_heat_exchanger.thermal_resistance.tips"})
    @NumberRange(range={0.0, 1.7976931348623157E308})
    private float thermalResistance = 1.0f;

    @Override
    public PNCHeatExchangerTrait createTrait(MBDMachine machine) {
        return new PNCHeatExchangerTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{(Item)ModItems.HEAT_FRAME.get()});
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 10, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)PNCHeatRecipeCapability.HUD_BAR));
        energyBar.setBackground(new IGuiTexture[]{PNCHeatRecipeCapability.HUD_BACKGROUND});
        energyBar.setId(prefix);
        TextTextureWidget energyBarText = new TextTextureWidget(5, 0, 90, 10).setText("0 temperature").textureStyle(texture -> texture.setDropShadow(true));
        energyBarText.setId(prefix + "_text");
        ui.addWidget((Widget)energyBar);
        ui.addWidget((Widget)energyBarText);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof PNCHeatExchangerTrait) {
            PNCHeatExchangerTrait heatTrait = (PNCHeatExchangerTrait)trait;
            String prefix = this.uiPrefixName();
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), ProgressWidget.class, energyBar -> {
                energyBar.setProgressSupplier(() -> heatTrait.getHandler().getTemperature() / 2273.0);
                energyBar.setDynamicHoverTips(value -> LocalizationUtils.format((String)"config.definition.trait.pneumatic_heat_exchanger.ui_container_hover", (Object[])new Object[]{Math.round(2273.0 * value) - 273L}));
            });
            WidgetUtils.widgetByIdForEach(group, "^%s_text$".formatted(prefix), TextTextureWidget.class, energyBarText -> energyBarText.setText(() -> Component.m_237113_((String)(Math.round(heatTrait.getHandler().getTemperature()) - 273L + "\u00b0C"))));
        }
    }

    public float getThermalCapacity() {
        return this.thermalCapacity;
    }

    public void setThermalCapacity(float thermalCapacity) {
        this.thermalCapacity = thermalCapacity;
    }

    public float getThermalResistance() {
        return this.thermalResistance;
    }

    public void setThermalResistance(float thermalResistance) {
        this.thermalResistance = thermalResistance;
    }
}

