/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.naturesaura.trait;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.IUIProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.naturesaura.trait.AuraHandlerTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

@LDLRegister(name="aura_handler", group="trait", modID="naturesaura")
public class AuraHandlerTraitDefinition
extends RecipeCapabilityTraitDefinition
implements IUIProviderTrait {
    @Configurable(name="config.definition.trait.aura_handler.radius", tips={"config.definition.trait.aura_handler.radius.tooltip"})
    @NumberRange(range={1.0, 64.0})
    private int radius = 20;

    @Override
    public ITrait createTrait(MBDMachine machine) {
        return new AuraHandlerTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{ModBlocks.NATURE_ALTAR.m_5456_()});
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        TextTextureWidget text = new TextTextureWidget(0, 0, 100, 10, LocalizationUtils.format((String)"recipe.capability.natures_aura.aura", (Object[])new Object[]{0})).textureStyle(t -> t.setType(TextTexture.TextType.LEFT));
        text.setId(this.uiPrefixName());
        ui.addWidget((Widget)text);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof AuraHandlerTrait) {
            String prefix = this.uiPrefixName();
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), TextTextureWidget.class, text -> text.setText(() -> {
                Level world = trait.getMachine().getLevel();
                BlockPos pos = trait.getMachine().getPos();
                return Component.m_237110_((String)"recipe.capability.natures_aura.aura", (Object[])new Object[]{IAuraChunk.getAuraInArea((Level)world, (BlockPos)pos, (int)((AuraHandlerTrait)trait).getDefinition().radius)});
            }));
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

